/* eme - a framework for a game map editor
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "alclean.h"

#include "debug.h"

#include <allegro.h>

#define BASE_LEN 256

#define UNICODE_CHAR_LEN 2


/* len in characters */
static void put_zero(char *str, int len)
{
  int i;
  for(i=0; i<SIZEOF_CHARACTER; i++) {
    str[(len-1) * SIZEOF_CHARACTER + i] = 0;
  }
}

static int test_zero(char *str, int len)
{
  int ret = 0;
  int i;
  for(i=0; i<SIZEOF_CHARACTER; i++) {
    ret = ret || str[(len-1) * SIZEOF_CHARACTER + i];
  }
  return ret;
}


/* al_clean_fix_filename_path
   ---------------------------------*/
char *al_clean_fix_filename_path(const char *path)
{
  int len = BASE_LEN;
  char *ret = malloc(len * SIZEOF_CHARACTER);

  if(!ret) {
    return NULL;
  }

  put_zero(ret, len);

  fix_filename_path(ret, path, len * SIZEOF_CHARACTER);
  while(test_zero(ret, len)) {
    len *= 2;
    ret = realloc(ret, len * SIZEOF_CHARACTER);
    if(!ret) {
      return NULL;
    }
    put_zero(ret, len);
    fix_filename_path(ret, path, len * SIZEOF_CHARACTER);
  }

  return ret;
}


/* al_clean_get_executable_name
   ---------------------------------*/
char *al_clean_get_executable_name(void)
{
  int len = BASE_LEN;
  char *ret = malloc(len * SIZEOF_CHARACTER);

  if(!ret) {
    return NULL;
  }

  put_zero(ret, len);

  get_executable_name(ret, len * SIZEOF_CHARACTER);
  while(test_zero(ret, len)) {
    len *= 2;
    ret = realloc(ret, len * SIZEOF_CHARACTER);
    if(!ret) {
      return NULL;
    }
    put_zero(ret, len);
    get_executable_name(ret, len * SIZEOF_CHARACTER);
  }

  return ret;
}


/* al_clean_get_full_executable_name
   ---------------------------------*/
char *al_clean_get_full_executable_name(void)
{
  char *ret;
  char *tmp;
  tmp = al_clean_get_executable_name();
  if(!tmp) {
    return NULL;
  }
  ret = al_clean_fix_filename_path(tmp);
  free(tmp);
  return ret;
}


char *al_clean_uconvert_dup(const char *str, int format, int new_format)
{
  int size = uconvert_size(str, format, new_format);
  char *ret = (char*)malloc(size);
  do_uconvert(str, format, ret, new_format, size);
  return ret;
}

