/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef SEME__PROPERTY__STRING__
#define SEME__PROPERTY__STRING__
/*------------------------------------------------------------------------------
  SemeString property

- Constructor/destructor
- Additional data
- Loading/saving format file
- Creating/loading/saving map
- Saving C code
- Internal functions and data
------------------------------------------------------------------------------*/

#include "debug.h"

#include "semeprop.h"

#define DEFAULT_LEN -1
#define SEME_DEFAULT_STRING EmptyString()


class SemeString: public SemeProperty {

public:
  SEME_GET_TYPE

  /* Constructor/destructor
     ---------------------------------*/
  static SemeProperty *Create(void);

  SemeString(void);
  ~SemeString(void);

  void SubCopyFrom(const SemeProperty *p);


  /* Additional data
     ---------------------------------*/
  int AskAdditionalData(void);
  const char *GetDataDescription(void);


  /* Load/Save format file
     ---------------------------------*/
  int LoadFormat(FILE *f, int num_indent);
  int SaveFormat(FILE *f, int num_indent) const;


  /* Creating/loading/saving map
     ---------------------------------*/
  BaseCreator *CreateCreator(void);

  BaseCreator *LoadProperty(PACKFILE *pf, int version);

  BaseProperty *LoadTile(PACKFILE *pf, int version, const BaseCreator *creator) const;

  int Save(PACKFILE *pf, int version, const BaseProperty *p) const;


  /* Saving C code
     ---------------------------------*/
  int SaveCStructField(FILE *f, int num_indent) const;
  int SaveCCode(
    FILE *f, int num_indent, const char *leading, const char *cleaning
  ) const;
  int SaveCCleanCode(FILE *f, int num_indent, const char *leading) const;


protected:
  /* Internal functions and data
     ---------------------------------*/
  SEME_TYPE

  int AdditionalData(void);

  static inline const SemeString *cast(const SemeProperty *p)
    { return dynamic_cast<const SemeString*>(p); }
  static inline SemeString *cast(SemeProperty *p)
    { return dynamic_cast<SemeString*>(p); }

private:
  SemeString(const SemeString&);
  SemeString &operator=(const SemeString&);

  int len;
};

#endif /* SEME__PROPERTY__STRING__ */

