/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "semedlg.h"

#include "sememngr.h"
#include "semeprop.h"

#include "translat.h"

#include <allegro.h>

#include <altheme.h>


int seme_button_proc(int msg, DIALOG *d, int c)
{
  HANDLE_HELP(msg, d, c);
  return altheme_button_proc(msg, d, c);
}


int seme_text_proc(int msg, DIALOG *d, int c)
{
  HANDLE_HELP(msg, d, c);
  return altheme_text_proc(msg, d, c);
}


int seme_radio_proc(int msg, DIALOG *d, int c)
{
  HANDLE_HELP(msg, d, c);
  return altheme_radio_proc(msg, d, c);
}


int seme_check_proc(int msg, DIALOG *d, int c)
{
  HANDLE_HELP(msg, d, c);
  return altheme_check_proc(msg, d, c);
}


int seme_edit_proc(int msg, DIALOG *d, int c)
{
  HANDLE_HELP(msg, d, c);
  return altheme_eedit_proc(msg, d, c);
}


int seme_list_proc(int msg, DIALOG *d, int c)
{
  HANDLE_HELP(msg, d, c);
  return altheme_list_proc(msg, d, c);
}


int seme_proplist_proc(int msg, DIALOG *d, int c)
{
  int ret;
  int old_d1 = d->d1;

  if(msg==MSG_DCLICK) {
    SemePropertyManager::AskAdditionalData(d->d1);
    ret = D_O_K;
  }
  else {
    ret = seme_list_proc(msg, d, c);
  }

  SemeProperty *p = SemePropertyManager::Get(d->d1);
  const char *desc = p->GetDataDescription();
  if(old_d1!=d->d1 || d[2].dp!=desc) {
    d[2].dp = (void*) desc;
    ret |= D_REDRAW;
  }
  return ret;
}


/* seme_type_cb:
 * Callback for getting the property type names, to display them in a list
 */
static char *seme_type_cb(int index, int *listsize, DIALOG * /*d*/)
{
  if(index>=0) {
    return (char*)SemePropertyManager::GetName(index);
  }
  else {
    *listsize = SemePropertyManager::Count();
    return 0;
  }
}


/* seme_data_proc:
 * Proc for the button the user click to enter additional data for the 
 * selected property
 */
static int seme_data_proc(int msg, DIALOG *d, int c)
{
  HANDLE_HELP(msg, d, c);
  if(msg == MSG_LPRESS || msg == MSG_KEY) {
    seme_button_proc(msg, d, c);
    scare_mouse_area(d->x, d->y, d->w, d->h);
    seme_button_proc(MSG_DRAW, d, c);
    unscare_mouse();
    while(mouse_b) {
    }
    if(IS_IN(d, mouse_x, mouse_y) || msg == MSG_KEY) {
      SemePropertyManager::AskAdditionalData(d[-1].d1);
    }
    d->flags &= ~D_SELECTED;
    return D_REDRAW;
  }
  return seme_button_proc(msg, d, c);
}


/*
 *
 */
static int seme_datatext_proc(int msg, DIALOG *d, int c)
{
  if(msg==MSG_DRAW) {
    int ret;
    char *text = (char*)d->dp;
    int len = text_length(font, text);

    if(len>d->w) {
      /* This works only if the font is fixed */
      int dw = (len-d->w) / text_length(font, SpaceString());
      char *t = (char*)(d->dp);
      for (int i=0; i<dw; i++) {
        ugetx(&t);
      }
      d->dp = t;
    }

    ret = seme_text_proc(msg, d, c);

    d->dp = text;
    return ret;
  }
  else {
    return seme_text_proc(msg, d, c);
  }
}




void dialog(DIALOG &d, int x, int y, int w, int h)
{
  d.x = x;
  d.y = y;
  d.w = w;
  d.h = h;
}


void dialog(DIALOG &d, int x, int y, int w, int h, const char *help)
{
  dialog(d, x, y, w, h);
  d.dp3 = (void*)help;
}


void dialog(DIALOG &d, int x, int y, int w, int h, const char *help, void *dp, int (*proc)(int, DIALOG*, int))
{
  dialog(d, x, y, w, h, help);
  d.dp = dp;
  d.proc = proc;
}


void end(DIALOG &d)
{
  d.proc = 0;
}


void box(DIALOG &d, int x, int y, int w, int h)
{
  dialog(d, x, y, w, h);
  d.proc = altheme_shadow_box_proc;
}


void title(DIALOG &d, int x, int y, int w, int h, const char *str)
{
  dialog(d, x, y, w, h);
  d.dp = (void*)str;
  d.proc = altheme_ctext_proc;
}


void text(DIALOG &d, int x, int y, int w, int h, const char *help, const char *str)
{
  dialog(d, x, y, w, h, help);
  d.dp = (void*)str;
  d.proc = seme_text_proc;
}


void radio(DIALOG &d, int x, int y, int w, int h, const char *help, int group, int flags, const char *str)
{
  dialog(d, x, y, w, h, help);
  d.dp = (void*)str;
  d.d1 = group;
  d.flags = flags;
  d.proc = seme_radio_proc;
}


void edit(DIALOG &d, int x, int y, int w, int h, const char *help, char *str, int len)
{
  dialog(d, x, y, w, h, help);
  d.dp = (void*)str;
  d.d1 = len;
  d.proc = seme_edit_proc;
}


void check(DIALOG &d, int x, int y, int w, int h, const char *help, int flags)
{
  dialog(d, x, y, w, h, help);
  d.flags = flags;
  d.proc = seme_check_proc;
}


void button(DIALOG &d, int x, int y, int w, int h, int key, int flags, const char *str)
{
  dialog(d, x, y, w, h);
  d.dp = (void*)str;
  d.key = key;
  d.flags = flags;
  d.proc = seme_button_proc;
}


void proplist(DIALOG &d, int x, int y, int w, int h, const char *help)
{
  dialog(d, x, y, w, h, help);
  d.dp = (void*)seme_type_cb;
  d.proc = seme_proplist_proc;
}


void databutton(DIALOG &d, int x, int y, int w, int h, const char *help, const char *str)
{
  dialog(d, x, y, w, h, help);
  d.dp = (void*)str;
  d.proc = seme_data_proc;
}


void datatext(DIALOG &d, int x, int y, int w, int h, const char *help)
{
  dialog(d, x, y, w, h, help);
  d.dp = (void*)EMPTY_STRING;
  d.proc = seme_datatext_proc;
}

