/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "semebool.h"

#include "semeprop.h"
#include "semefile.h"
#include "semevrsn.h"

#include "debug.h"
#include "utils.h"
#include "ustring.h"

#include <altheme.h>

#include <allegro.h>

#include "cbool.h"
typedef Boolean::Creator BooleanCreator;
typedef Boolean::Property BooleanProperty;


static const UString &usBoolean()
{
  static const UString str("Boolean");
  return str;
}
SEME_REGISTER(SemeBoolean, usBoolean(), SemeBoolean::Create);


/* Constructor/destructor
   ---------------------------------*/
SemeProperty *SemeBoolean::Create(void)
{
  SemeProperty *ret = new SemeBoolean();
  CHECK_POINTER(ret);
  return ret;
}


SemeBoolean::SemeBoolean(void): SemeProperty()
{
}


SemeBoolean::~SemeBoolean(void)
{
}


void SemeBoolean::SubCopyFrom(const SemeProperty * /*p*/)
{
}


/* Additional data -- none
   ---------------------------------*/


/* Loading/saving format file
   ---------------------------------*/
int SemeBoolean::SaveFormat(FILE * /*f*/, int /*num_indent*/) const
{
  return 1;
}


int SemeBoolean::LoadFormat(FILE * /*f*/, int /*num_indent*/)
{
  return 1;
}


/* Creating/loading/saving map
   ---------------------------------*/
BaseCreator *SemeBoolean::CreateCreator(void)
{
  BaseCreator *ret = new BooleanCreator(GetName(), SEME_DEFAULT_BOOLEAN);
  return ret;
}


BaseCreator *SemeBoolean::LoadProperty(PACKFILE *pf, int version)
{
  int val = pack_getc(pf);
  BooleanCreator *creator=new BooleanCreator(GetName(), val);
  return creator;
}


BaseProperty *SemeBoolean::LoadTile(
  PACKFILE *pf, int version, const BaseCreator *creator
) const
{
  const BooleanCreator *bc = Cast<Boolean>(creator);
  int val = pack_getc(pf);
  return bc->Create(val);
}


int SemeBoolean::Save(PACKFILE *pf, int version, const BaseProperty *p) const
{
  const BooleanProperty *pb = Cast<Boolean>(p);
  return pack_putc(pb->Get(), pf) != EOF;
}


/* Saving C code
   ---------------------------------*/
int SemeBoolean::SaveCStructField(FILE *f, int num_indent) const
{
  char *str = CleanForC(GetName()->string());
  if(!str) {
    return 0;
  }
  Print(
    f, num_indent, "unsigned char %s; /* %s */", str,
    SemePropertyManager::GetAsciiName(GetType())
  );
  free(str);
  return 1;
}


int SemeBoolean::SaveCCode(
  FILE *f, int num_indent, const char *leading, const char * /*cleaning*/
) const
{
  char *str = CleanForC(GetName()->string());
  if(!str) {
    return 0;
  }
  Print(f, num_indent, "%s%s = pack_getc(file);", leading, str);
  free(str);
  return 1;
}


int SemeBoolean::SaveCCleanCode(
  FILE * /*f*/, int /*num_indent*/, const char * /*leading*/
) const
{
  return 1;
}

