/* seme - a simple map editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#include "semeaddl.h"

#include "semedlg.h"

#include "translat.h"
#include "alclean.h"

#include <stdlib.h>
#include <allegro.h>

#include "semenew.h"
#include "sememap.h"
#include "semeprop.h"



/*------------------------------------------------------------------------------
  Add Prop Dialog
------------------------------------------------------------------------------*/

/* Indices to the dialog array 'get_prop_dialog()' */
typedef enum {
  ADD_LAYER_BOX,
  ADD_LAYER_TITLE,

  /* The layer name */
  ADD_LAYER_TEXT1,
  ADD_LAYER_NAME,   /* d->dp: layer name */

  /* The layer fullness */
  ADD_LAYER_FULL,   /* d->flags&D_SELECTED: the layer is full */
  ADD_LAYER_SPARSE, /* d->flags&D_SELECTED: the layer is sparse */

  /* The layer type */
  ADD_LAYER_TEXT2,
  ADD_LAYER_TYPE,   /* d->d1: index of the layer type */

  /* The layer additional data */
  ADD_LAYER_BUTTON,
  ADD_LAYER_DATA,   /* d->dp: string to display the additional data */

  ADD_LAYER_OK,
  ADD_LAYER_CANCEL,
  NUM_ADD_LAYER_DIALOGS
} ADD_LAYER_DIALOG;

#define NAME_LEN 256
static char name_str[(NAME_LEN+1)*SIZEOF_CHARACTER] = EMPTY_STRING;

static const Translation i18nProperty("Layer");
static const Translation i18nName("Name");
static const Translation i18nFull("Full");
static const Translation i18nSparse("Sparse");
static const Translation i18nType("Type");
static const Translation i18nData("Data");
static const Translation i18nOK("OK");
static const Translation i18nCancel("Cancel");


DIALOG *get_layer_dialog()
{
  static DIALOG dlg[NUM_ADD_LAYER_DIALOGS+1];
  static bool initialized = false;
  if (!initialized) {
    int i=0;

    box(dlg[i++],     0, 0, 320, 200);
    title(dlg[i++], 160, 8, 160, 20, i18nProperty);

    text(dlg[i++],  8, 38,  60, 20, LAYER_NAME_HELP, i18nName);
    edit(dlg[i++], 68, 38, 244, 20, LAYER_NAME_HELP, name_str, NAME_LEN);

    int group = 1;
    radio(dlg[i++],  8, 56, 60, 16, LAYER_FULLNESS_HELP, group, D_DISABLED|D_SELECTED, i18nFull);
    radio(dlg[i++], 68, 56, 60, 16, LAYER_FULLNESS_HELP, group, D_DISABLED           , i18nSparse);

    text(dlg[i++],      8, 84,  60, 20, LAYER_TYPE_HELP, i18nType);
    proplist(dlg[i++], 68, 84, 244, 44, LAYER_TYPE_HELP);

    databutton(dlg[i++], 8, 144,  54, 20, LAYER_DATA_HELP, i18nData);
    datatext(dlg[i++],  68, 144, 244, 20, LAYER_DATA_HELP);

    button(dlg[i++],   8, 172, 80, 20, '\r', D_EXIT, i18nOK);
    button(dlg[i++], 232, 172, 80, 20,    0, D_EXIT, i18nCancel);

    end(dlg[i]);

    initialized = true;
  }
  return dlg;
}


/* popup_add_layer:
 * popups a dialog for editing a layer
 */
const SemeProperty *popup_add_layer(SemeProperty *p)
{
  if(p) {
    ustrzcpy(
      get_layer_name(), NAME_LEN*SIZEOF_CHARACTER,
      p->GetName()->string()
    );
    get_layer_dialog()[ADD_LAYER_TYPE].d1 = p->GetType();
    SemePropertyManager::Get(get_layer_type())->CopyFrom(p);
  }
  set_dialog_color(get_layer_dialog(), gui_fg_color, gui_bg_color);
  centre_dialog(get_layer_dialog());
  int ret = popup_dialog(get_layer_dialog(), -1);
  if(ret == ADD_LAYER_OK) {
    SemeProperty *pp = SemePropertyManager::Get(get_layer_type());
    pp->SetName(get_layer_name());
    return SemePropertyManager::Get(get_layer_type());
  }
  else {
    return 0;
  }
}


char *get_layer_name()
{
  return (char*)get_layer_dialog()[ADD_LAYER_NAME].dp;
}

int get_layer_type()
{
  return get_layer_dialog()[ADD_LAYER_TYPE].d1;
}

