/* ieme - a simple bitmap editor based on eme
 *
 * Copyright (C) 2002 Annie Testes
 *
 * This code is placed under the GNU General Public License.
 * Please refer to the accompanying file 'copying.txt' for details.
 */
#ifndef ALXPM_H_
#define ALXPM_H_

/*
 * Three functions are exported:
 *
 * BITMAP *load_xpm(const char *fname, RGB *pal)
 *  Reads an XPM from a file, suitable for 'register_bitmap_file_type'.
 *  Returns NULL on error. 'pal' can be NULL.
 *  Note; can handle only pixels coded on one character
 *  Note: in 8 bits, assumes color None (transparent) is the first one.
 *  Note: if the file format is bogus, may crash.
 *
 * BITMAP *convert_xpm(char *lines[], RGB *pal)
 *  Converts an included XPM to a BITMAP.
 *  Returns NULL on error. 'pal' can be NULL.
 *  Note; can handle only pixels coded on one character
 *  Note: in 8 bits, assumes color None (transparent) is the first one.
 *  Note: if the file format is bogus, may crash.
 *
 * int save_xpm(const char *fname, BITMAP *bmp, const RGB *pal)
 *  Saves a BITMAP to a file, suitable for 'register_bitmap_file_type'.
 *  Returns non-zero on error, 'pal' can be NULL.
 *  Note: can handle at most 94 colors.
 *
 * General Notes:
 *  If compiled with -DTEST_MAIN, produces a test executable.
 *  Never tested in 8 bits
 */
#ifdef __cplusplus
extern "C" {
#endif

struct BITMAP;
struct RGB;

struct BITMAP *load_xpm(const char *fname, struct RGB *pal);
struct BITMAP *convert_xpm(char *lines[], struct RGB *pal);
int save_xpm(const char *fname, struct BITMAP *bmp, const struct RGB *pal);

#ifdef __cplusplus
}
#endif


#endif /* ALXPM_H_ */

