/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


enum WEAPON_STATUS {WEAPON_SELECTED = 0, WEAPON_GATHERED = 1, WEAPON_INACTIVE = 2};


#ifndef SERVER_ONLY


#ifndef WEAPON_STATUS_H
#define WEAPON_STATUS_H

#include "complex_object_extension.h"

#include <string>

#define WEAPON_STATUS_STR std::string("weapon_status")

class ProgressBar;
class Text;
class Sprite;


class WeaponStatus : public ComplexObjectExtension {
public:
	WeaponStatus(const TiXmlElement *Att, const Rect<float> &ParentSize, bool SrvMode);

	void SetStatus(WEAPON_STATUS BarStatus);
	void SetAmmoCount(USHORT Count);
	void SetName(std::string Name);
	void SetAmmoLimit(USHORT Limit) {AmmoLimit = Limit;}

private:
	Sprite *BaseSprite;

	Text *AmmoCountDisplayBig;
	Text *AmmoCountDisplaySmall;
	Text *Name;
	ProgressBar *AmmoProgress;

	USHORT AmmoLimit;
	USHORT Ammo;
};

#endif

#endif //SERVER_ONLY
