/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "weapon_status.h"

#include "progress_bar.h"
#include "text.h"
#include "sprite.h"


#define TEXT_STR std::string("text")
#define AMMO_BIG_STR std::string("ammo_big")
#define AMMO_SMALL_STR std::string("ammo_small")
#define AMMO_PROGRESS_STR std::string("ammo_progress")


WeaponStatus::WeaponStatus(const TiXmlElement *Att, const Rect<float> &ParentSize, bool SrvMode) :
	ComplexObjectExtension(Att, ParentSize, SrvMode) {

	const TiXmlElementList* Child = XMLParser::GetChildren(Att, TEXT_STR);
	for (USHORT x = 0; x < Child->size(); ++x) {
		SpriteLayer.push_back(new Text(Child->at(x), ParentSize));
	}
	delete Child;

	const TiXmlElement *Element = XMLParser::GetChild(Att, AMMO_SMALL_STR);
	AmmoCountDisplaySmall = new Text(Element, ParentSize);
	SpriteLayer.push_back(AmmoCountDisplaySmall);

	Element = XMLParser::GetChild(Att, AMMO_BIG_STR);
	AmmoCountDisplayBig = new Text(Element, ParentSize);
	SpriteLayer.push_back(AmmoCountDisplayBig);

	Element = XMLParser::GetChild(Att, AMMO_PROGRESS_STR);
	AmmoProgress = new ProgressBar(Element, ParentSize);
	SpriteLayer.push_back(AmmoProgress);

	BaseSprite = GetBaseSprite(Att, ParentSize);
	BaseSprite->Pause();
}


void WeaponStatus::SetStatus(WEAPON_STATUS BarStatus) {
	if (BaseSprite->GetCurrentFrame() != BarStatus) {
		BaseSprite->JumpToFrame(BarStatus);
		AmmoCountDisplayBig->SetVisible(BarStatus == WEAPON_SELECTED);
		AmmoCountDisplaySmall->SetVisible(BarStatus != WEAPON_INACTIVE);
	}
}


void WeaponStatus::SetAmmoCount(USHORT Count) {
	_SPARKLET_ASSERT(Count <= AmmoLimit);
	Ammo = Count;
	AmmoCountDisplayBig->SetText(Count);
	AmmoCountDisplaySmall->SetText(Count);
	AmmoProgress->SetPercent(Count / (float)AmmoLimit);
}


void WeaponStatus::SetName(std::string WeaponName) {
	Name->SetText(WeaponName);
}


#endif //SERVER_ONLY
