/***************************************************************************
                          rock.h  -  description
                             -------------------
    begin                : Mon Mar 31 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com   
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 /**
  *@author Milan Mimica
  */


#ifndef WALL_H
#define WALL_H


#include "rectangle_object.h"
#include "non-rotated_object.h"

#include "initializer.h"

#define WALL_STR std::string("wall")


class Sound;


class Wall : public RectangleObject, public NonRotatedObject {
public:
	Wall(const TiXmlElement* Att, float Scale = 1.f);
	~Wall();

	virtual void OnUpdate();

	static const ULONG ID;
	virtual const ULONG GetTypeID() const {return ID;}

private:
	Sound *CollideSound;

	virtual void Damage(const PhysicalObject *Obj);
};

DECLARE_FACTORY(Wall, Object)

#endif
