/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef TEXT_OBJECT_H
#define TEXT_OBJECT_H


#include <string>

#include "structures.h"


class TextObject {
public:
	TextObject(const Point<float> &Loc, const std::string &Text, const int &Font, const int &Color);
	TextObject(const int &Font);

	void Display();
	void Update();

	void SetLoc(const Point<float> &lLoc) {Loc = lLoc;}
	void SetText(const std::string &lText);
	void SetColor(const int &lColor) {Color = lColor;}

	void FadeOut() {FadingOut = true;}

private:
	Point<float> Loc;
	std::string Text;
	int Font;
	int Color;

	bool FadingOut;
	const float FadeOutDelay;
	float FadeOutDelayCounter;
};


#endif

#endif //SERVER_ONLY
