/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "text.h"

#include <sstream>
#include "agl_text.h"
#include "fonts.h"
#include "font_server.h"


#define TEXT_STR std::string("text")
#define FONT_STR std::string("font")
#define COLOR_STR std::string("color")
#define BGCOLOR_STR std::string("bg_color")
#define MAX_WIDTH_STR std::string("max_width")


extern FontServer *gFntSrv;


Text::Text(const TiXmlElement *Element, const Size &Parent) :
	ObjectExtension(Element, Parent, false),
	Value(""),
	Visible(true),
	Font(DEFAULT),
	Color(0xffffffff) {

	Color = XMLParser::GetValueUL(Element, COLOR_STR, 0xffffffff);
	Value = XMLParser::GetValueS(Element, TEXT_STR, "");
	Font = XMLParser::GetValueL(Element, FONT_STR, DEFAULT);
	MaxWidth = XMLParser::GetValueL(Element, MAX_WIDTH_STR, -1);
}


void Text::Render(const Point<float> &Where, const float &) const {
	if (Visible)
		WriteText(Where + static_cast<Point<float> >(Geo), Value, Font, Color);
}


bool Text::SetText(const std::string Val) {
	if (MaxWidth == -1 ||
		text_length(gFntSrv->GetFont(Font), Val.c_str()) <= MaxWidth * ((float)SCREEN_W / UNITS_PER_SCREEN_W)) {
		Value = Val;
		return true;
	}
	else
		return false;
}


bool Text::SetText(const int Val) {
	std::ostringstream oss;
	oss << Val;
	return SetText(oss.str());
}


bool Text::SetText(const float Val) {
	std::ostringstream oss;
	oss << Val;
	return SetText(oss.str());
}


bool Text::SetText(const double Val) {
	std::ostringstream oss;
	oss << Val;
	return SetText(oss.str());
}


USHORT Text::GetMaxTextLen() const {
	const float MaxTextWidth = MaxWidth * ((float)SCREEN_W / UNITS_PER_SCREEN_W);
	const float CharWidth = text_length(gFntSrv->GetFont(Font), "A");
	return (USHORT)(MaxTextWidth / CharWidth);
}


#endif //SERVER_ONLY
