/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include <allegro.h>
#ifdef WIN32
	#include <winalleg.h>
#endif


#include "statusbar.h"

#include "text.h"
#include "weapon_status.h"

#include "network_messages.h"
#include <sstream>

#define PLAYER_NAME_STR std::string("player_name")
#define PLAYER_ENERGY_STR std::string("player_energy")
#define RANK_STR std::string("rank")
#define POINTS_STR std::string("points")
#define ADVANTAGE_STR std::string("advantage")

#define INDEX_STR std::string("index")


Statusbar::Statusbar(const TiXmlElement *Root, const Size &Dim, float) :
	GuiObject(Root, Dim) {

	const TiXmlElement *Element = XMLParser::GetChild(Root, PLAYER_NAME_STR);
	PlayerName = new Text(Element, Dim);
	Extension.push_back(PlayerName);

	Element = XMLParser::GetChild(Root, PLAYER_ENERGY_STR);
	PlayerEnergy = new Text(Element, Dim);
	Extension.push_back(PlayerEnergy);

	Element = XMLParser::GetChild(Root, RANK_STR);
	Rank = new Text(Element, Dim);
	Extension.push_back(Rank);

	Element = XMLParser::GetChild(Root, POINTS_STR);
	Points = new Text(Element, Dim);
	Extension.push_back(Points);

	Element = XMLParser::GetChild(Root, ADVANTAGE_STR);
	Advantage = new Text(Element, Dim);
	Extension.push_back(Advantage);

	InitialEnergyColor = PlayerEnergy->GetColor();
}


WeaponStatus* Statusbar::GetWeaponStatus(const TiXmlElement *Root) {
	WeaponStatus *RetVal;

	int Index = XMLParser::GetValueL(Root, INDEX_STR, -1);
	std::map<int, WeaponStatus*>::iterator it = WeaponStatusList.find(Index);

	if (it == WeaponStatusList.end()) {
		const TiXmlElement *Element = XMLParser::GetChild(Root, WEAPON_STATUS_STR);
		RetVal = new WeaponStatus(Element, GetGeo(), false);
		WeaponStatusList.insert(WeaponStatusList.end(), make_pair(Index, RetVal));
		Extension.push_back(RetVal);
	}
	else
		RetVal = it->second;

	return RetVal;
}


void Statusbar::SetPlayerName(const std::string &Name) {
	PlayerName->SetText(Name);
}


void Statusbar::SetEnergy(USHORT Energy) {
	std::ostringstream oss;
	oss << Energy << "%";
	PlayerEnergy->SetText(oss.str());

	if (Energy < 31)
		PlayerEnergy->SetFontColor(makeacol32(255, (int)((Energy / 30.f) * 191), 0, 255));
	else
		PlayerEnergy->SetFontColor(InitialEnergyColor);
}


void Statusbar::SetScore(char lPoints, char lPointsMax, char lAdvantage, UCHAR lRank, UCHAR lOf) {
	std::ostringstream rank_oss;
	rank_oss << (int)lRank << "/" << (int)lOf;
	Rank->SetText(rank_oss.str());

	std::ostringstream points_oss;
	points_oss << (int)lPoints << "/" << (int)lPointsMax;
	Points->SetText(points_oss.str());

	if (lAdvantage > 0) {
		std::ostringstream adv_oss;
		adv_oss << "+" << (int)lAdvantage;
		Advantage->SetText(adv_oss.str());
	}
	else
		Advantage->SetText(lAdvantage);
}


#endif //SERVER_ONLY
