/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef STAR_H
#define STAR_H

#include <alleggl.h>

#include "structures.h"
#include "agl_bitmap.h"

#include <string>


class Star {
public:
	Star(Point<float> l, float lz, int d) :
	Loc(l),
	Depth(d),
	z(lz),
	off(0.8f + Depth / 255.f/* * 1.f*/) {}

	void Draw(const Rect<float> &CG) const {
		const float x = Loc.x - CG.x / z;
		const float y = Loc.y - CG.y / z;

		if (x > SCREEN_W || y > SCREEN_H || x < 0 || y < 0)
			return;

		glColor3ub(Depth, Depth, Depth);

		glPointSize(off);
		glBegin(GL_POINTS);
			glVertex2f(x, y);
		glEnd();

		glColor3ub(255, 255, 255);
	}

private:
	const Point<float> Loc;
	const UCHAR Depth;
	const float z;
	const float off;
};


struct DrawStar {
	DrawStar(const Rect<float> &CG) : CameraGeo(CG) {}
	void operator() (const Star* s) {
		s->Draw(CameraGeo);
	}

private:
	const Rect<float> &CameraGeo;
};


#endif

#endif //SERVER_ONLY
