/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SPARKLET_UTILS_H
#define SPARKLET_UTILS_H

#include "structures.h"

#include <map>


/*Returns given angle bounded between -pi an pi.*/
float BoundAngle(float Angle);


/*
'TargetObjectLoc' is the target the camera should normaly point to.
'CameraDim' is the size of the camera.
'ArenaSize' is the size of arena.
Returns a target camera, usually following the target object but voiding arena edges.*/
Point<float> GetCameraTargetSmart(const Point<float> &TargetObjectLoc, const Size &CameraDim, const Size &ArenaSize);

/*
'OldCamera' is the initial camera.
'TargetLoc' is the target camera location.
Returns the new, interpolated camera location.*/
Point<float> CalcCameraLoc(Point<float> OldCamera, const Point<float> &TargetLoc);

/*
'OldCamera' is the initial camera.
'TargetDim' is the target camera size.
Returns the new, interpolated camera size.*/
Size CalcCameraDim(Size OldCamera, const Size &TargetDim);


/*Returns the Point centered in the middle of Geo*/
Point<float> GetCenter(const Rect<float> &Geo);


/*Fixes platform-dependent file-system slashes and returns the fixed string.*/
std::string FixFilenameSlashes(const std::string &S);


#ifdef WIN32
/*C99 already defines this function so it's only needed for obsolete MS compiler.
Round the given float value to the nearest integer, away from zero, and returns it.*/
int lroundf(const float v);
#endif


/*Returns the RGBA value adapted for ship tinting based on given team code.*/
int GetTeamTintColor(const TEAM &Team);

/*Returns the RGBA value based on given team code.*/
int GetTeamColor(const TEAM &Team);


/*Returns the name of the team*/
std::string GetTeamName(const TEAM &Team);


TEAM GetTeamFromName(const std::string &TeamName);

/*Parses a string of type wxh and returns Size filled in.*/
Size ParseDimensionString(const std::string &Dim);

/*Formats a string of type wxh and return it.*/
std::string FormatDimensionString(const Size &Dim);


/* Returns true if passed string are the same, case insesitive. */
bool CaseInsensitiveMatch(std::string str1, std::string str2);


/*Physical resistance formula.*/
template<class Type> static Type CalcResistance(Type Value, float Factor) {
		return abs(Value) * Value * Factor;
}


/*Same as calling mmap::at() which exits only in GNU c++.
Throws an int exception if the element with the given key doesn't exist.*/
template <typename _Key, typename _Tp>
_Tp& get_element(std::map<_Key, _Tp> &m, const _Key &k) {
	typename std::map<_Key, _Tp>::iterator it = m.find(k);
	if (it == m.end())
		throw 0;
	return it->second;
}


#endif

