/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SOUND_SAMPLE_H
#define SOUND_SAMPLE_H


#ifdef WIN32
	#include <allegro.h>
	#include <winalleg.h>
#endif

#include "xmlparser.h"
#include "structures.h"


class NewSoundInfoUntunable;
class NewSoundInfo;
class AdjustSoundInfo;
struct SAMPLE;


class SoundSample {
public:
	SoundSample(const NewSoundInfoUntunable *NSI, const std::string &Path);
	SoundSample(const NewSoundInfo *NSI, const std::string &Path);
	~SoundSample();

	void Play();
	void Adjust(const AdjustSoundInfo *ASI);

private:
	const SAMPLE *Sample;
	UCHAR Priority;
	UCHAR Volume;
	int PlayMode;
	UCHAR Pan;
	bool Playing;
	int Voice;

	int AdaptPlayMode(UCHAR PM) const;
};

#endif
