/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "sound_sample.h"
#include "sample_server.h"
#include "network_messages.h"
#include "sparklet_utils.h"

#include <string>
#include <map>


#define PLAY_MODE_STR std::string("play_mode")
#define PRIORITY_STR std::string("priority")
#define VOLUME_STR std::string("volume")


extern SampleServer *gSmpSrv;


SoundSample::SoundSample(const NewSoundInfoUntunable *NSIU, const std::string &Path) :
	Sample(gSmpSrv->GetSample(Path)),
	Priority(NSIU->Priority),
	Volume(NSIU->Volume),
	PlayMode(AdaptPlayMode(NSIU->PlayMode)),
	Pan(NSIU->Pan),
	Playing(false),
	Voice(0) {
}


SoundSample::SoundSample(const NewSoundInfo *NSI, const std::string &Path) :
	Sample(gSmpSrv->GetSample(Path)),
	Priority(NSI->Priority),
	Volume(255),
	PlayMode(AdaptPlayMode(NSI->PlayMode)),
	Pan(127),
	Playing(false),
	Voice(0) {
}


int SoundSample::AdaptPlayMode(UCHAR PM) const {
	int RetVal = 0;

	if (PM & PM_PLAY)
		RetVal |= PLAYMODE_PLAY;
	if (PM & PM_LOOP)
		RetVal |= PLAYMODE_LOOP;
	if (PM & PM_FORWARD)
		RetVal |= PLAYMODE_FORWARD;
	if (PM & PM_BACKWARD)
		RetVal |= PLAYMODE_BACKWARD;
	if (PM & PM_BIDIR)
		RetVal |= PLAYMODE_BIDIR;

	return RetVal;
}


SoundSample::~ SoundSample() {
	if (Playing)
		deallocate_voice(Voice);
}


void SoundSample::Play() {
	if (!Sample)
		return;

	if (Playing == false) {
		Voice = allocate_voice(Sample);
		voice_set_priority(Voice, Priority);
		voice_set_playmode(Voice, PlayMode);
		voice_set_volume(Voice, Volume);
		voice_set_pan(Voice, Pan);
		voice_start(Voice);

		/*If the sample has to be played only once it has to be self-destroyed once it is played.
		It should be safe to release the voice (allegro will dealocate once the voice ends) and
		delete the object.*/
		if ((PlayMode & PLAYMODE_LOOP) == 0) {
			release_voice(Voice);
			Playing = false;
			delete this;
			return;
		}
	}

	Playing = true;
}


void SoundSample::Adjust(const AdjustSoundInfo *ASI) {
	if (!Voice)
		return;

	Pan = ASI->Pan;
	Volume = ASI->Volume;

	if (Playing) {
		voice_set_pan(Voice, Pan);
		voice_set_volume(Voice, Volume);
	}
}
