/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef SOUND_H
#define SOUND_H

#include <allegro.h>
#ifdef WIN32
	#include <winalleg.h>
#endif

#include "structures.h"
#include "network_messages.h"
#include "network_server.h"
#include "xmlparser.h"
#include "sparklet_utils.h"


#define PLAY_MODE_STR std::string("play_mode")
#define PRIORITY_STR std::string("priority")
#define VOLUME_STR std::string("volume")


extern NetworkServer *gNetworkServer;


class Sound {
public:
	Sound(const TiXmlElement* Element, const Point<float> &Loc) :
		SoundUID(++CurrentSoundUID),
		PlayMode(CodePlayMode(Element)),
		Priority(XMLParser::GetValueL(Element, PRIORITY_STR, 128)),
		InitVolume(XMLParser::GetValueL(Element, VOLUME_STR, 255)),
		PathCode(gNetworkServer->GetCodeFromPath(FixFilenameSlashes(XMLParser::GetValueS(Element, SOURCE_STR, "")))),
		Source(Loc) {

	}

	Sound(const Sound &S) :
		SoundUID(S.SoundUID),
		PlayMode(S.PlayMode),
		Priority(S.Priority),
		InitVolume(S.InitVolume),
		PathCode(S.PathCode),
	/* Hack: A copy constructor is used only for Non-tunable souds, ie ther position is fixed, Source doesn't change.
	 * For Non-tunable sounds it is allowed that object that made them is destroyed before the sound object is played,
	 * so we have to remember th esound Source. */
		SourceReference(S.Source),
		Source(SourceReference) {
	}

	const OUIDInfo SoundUID;
	const UCHAR PlayMode;
	const UCHAR Priority;
	const UCHAR InitVolume;
	const USHORT PathCode;

/* reordered for initialization sequence */
private:
	const Point<float> SourceReference;

public:
	const Point<float> &Source;

private:
	static OUIDInfo CurrentSoundUID;

	char CodePlayMode(const TiXmlElement* Element) const {
		const std::string PlayModeStr = XMLParser::GetValueS(Element, PLAY_MODE_STR, "");

		if (PlayModeStr == "loop_forward")
			return PM_LOOP | PM_FORWARD;
		if (PlayModeStr == "loop_backward")
			return PM_LOOP | PM_BACKWARD;
		if (PlayModeStr == "play_forward")
			return PM_PLAY | PM_FORWARD;
		if (PlayModeStr == "play_backward")
			return PM_PLAY | PM_BACKWARD;
		if (PlayModeStr == "loop_bidir")
			return PM_LOOP | PM_BIDIR;
		else
			return PM_PLAY | PM_FORWARD;
	}
};


#endif
