/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef SERVER_SELECTOR_H
#define SERVER_SELECTOR_H


#include <MASkinG.h>

#include <zig/serverinfo.h>
#include "structures.h"


class ServerInfo;


class ServersDialogGeneric : public MAS::Dialog, protected serverinfo_listener_i {
public:
	ServersDialogGeneric();

	std::string GetIP();
	std::string GetPort();
	void Process();

protected:
	serverinfo_c ServerScanner;
	MAS::Button bRefresh;

	void InsertServer(const ServerInfo *SI, const std::string &IP, const int Ping);
	virtual void HandleEvent(Widget &obj, int msg, int arg1 = 0, int arg2 = 0);
	virtual void RequestServerInfo() = 0;

private:
	MAS::ListBoxEx lbServerList;

	virtual void serverinfo_timeout(address_c &addr, int time_ms);
	virtual void serverinfo_local_timeout(int time_ms);
};


class LANServersDialog : public ServersDialogGeneric {
public:
	LANServersDialog();

private:
	void RequestServerInfo();
	virtual void serverinfo_local_result(address_c &addr, buffer_c &info, int time_ms);
	virtual void serverinfo_result(address_c &addr, buffer_c &info, int time_ms) {}
};


class InternetServersDialog : public ServersDialogGeneric {
private:
	void RequestServerInfo();
	bool RetrieveServerList(const std::string &web_address, const std::string &web_file);
	virtual void serverinfo_result(address_c &addr, buffer_c &info, int time_ms);
	virtual void serverinfo_local_result(address_c &addr, buffer_c &info, int time_ms) {}
};


class SingleServerDialog : public MAS::Dialog {
public:
	SingleServerDialog();
	~SingleServerDialog();

	std::string GetIP() {return eIP.GetText();}
	std::string GetPort() {return ePort.GetText();}

private:
	MAS::EditBox eIP, ePort;
	MAS::Label lIP, lPort;
};


class ServerSelector : public MAS::Dialog {
public:
	ServerSelector();

	std::string GetSelectedAddress();
	void Process() {LSD.Process(), ISD.Process();}

private:
	MAS::TabPanel TP;

	LANServersDialog LSD; // :-)
	InternetServersDialog ISD;
	SingleServerDialog SSD;

	int TabIndexActive;

	virtual void HandleEvent(Widget &obj, int msg, int arg1 = 0, int arg2 = 0);
};


#endif

#endif //SERVER_ONLY
