/***************************************************************************
                          rock.h  -  description
                             -------------------
    begin                : Mon Mar 31 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 /**
  *@author Milan Mimica
  */


#ifndef ROCK_H
#define ROCK_H


#include "initializer.h"
#include "round_object.h"
#include "non-rotated_object.h"

#include <vector>

#define ROCK_STR std::string("rock")

class Sprite;


class Rock : public RoundObject, public NonRotatedObject {
public:
	Rock(const TiXmlElement* Att, float Scale = 1.f);
	~Rock();

	virtual void OnUpdate();
	const ULONG GetTypeID() const {return GEN_ID('r', 'o', 'o', 'b');}

private:
	Sprite *BaseSprite;

	const TiXmlElement *Piece;

	const TiXmlElementList *SmokeList;

	float Strength;
	float HitAngle;
	float Scaled;

	void FallAPart();
	void DoSmoke();
};

DECLARE_FACTORY(Rock, Object)

#endif
