/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "rectangle_object.h"
#include "sparklet_utils.h"


RectangleObject::RectangleObject(const TiXmlElement *Att, float Scale) :
	Object(Att, Scale),
	MobileObject(Att, Scale),
	PhysicalObject(Att, Scale) {
}


float RectangleObject::GetSurfaceNormal(const Point<float> &Loc) const {
	if (Loc.x <= Geo.x || Loc.y <= Geo.y || Loc.x >= Geo.x + Geo.Width || Loc.y >= Geo.y + Geo.Height)
		return Outside(Loc);
	else
		return Inside(Loc);
}


float RectangleObject::Inside(const Point<float> Loc) const {
	if (Geo.Height < Geo.Width) {
		const Point<float> HotSpot1 = Point<float>(Geo) + Point<float>(Geo.Height / 2.f, Geo.Height / 2.f);
		const Point<float> HotSpot2 = Point<float>(Geo) + Point<float>(Geo.Width - Geo.Height / 2.f, Geo.Height / 2.f);

		if (arg(Loc - HotSpot1) < -M_PI + M_PI / 4.f || arg(Loc - HotSpot1) > M_PI - M_PI / 4.f)
			return M_PI;

		if (arg(Loc - HotSpot1) < M_PI - M_PI / 4.f && arg(Loc - HotSpot1) > 0 && arg(Loc - HotSpot2) > M_PI / 4.f)
			return M_PI / 2.f;

		if (arg(Loc - HotSpot2) < M_PI / 4.f && arg(Loc - HotSpot2) > -M_PI / 4.f)
			return 0;

		if (arg(Loc - HotSpot1) > -M_PI + M_PI / 4.f && arg(Loc - HotSpot1) < 0 && arg(Loc - HotSpot2) < -M_PI / 4.f)
			return -M_PI / 2.f;
	}
	else {
		const Point<float> HotSpot1 = Point<float>(Geo) + Point<float>(Geo.Width / 2.f, Geo.Width / 2.f);
		const Point<float> HotSpot2 = Point<float>(Geo) + Point<float>(Geo.Width / 2.f, Geo.Height - Geo.Width / 2.f);

		if ((arg(Loc - HotSpot1) < -M_PI + M_PI / 4.f || arg(Loc - HotSpot1) > M_PI / 2.f) && (arg(Loc - HotSpot2) > M_PI - M_PI / 4.f || arg(Loc - HotSpot2) < -M_PI / 2.f))
			return M_PI;

		if (arg(Loc - HotSpot2) < M_PI - M_PI / 4.f && arg(Loc - HotSpot2) > M_PI / 4.f)
			return M_PI / 2.f;

		if (arg(Loc - HotSpot2) < M_PI / 4.f && arg(Loc - HotSpot2) > -M_PI / 2.f && arg(Loc - HotSpot1) > -M_PI /4.f)
			return 0;

		if (arg(Loc - HotSpot1) > -M_PI + M_PI / 4.f && arg(Loc - HotSpot1) < -M_PI / 4.f)
			return -M_PI / 2.f;
	}

	return 0;
}


float RectangleObject::Outside(const Point<float> Loc) const {
	if (Loc.x <= Geo.x) {
		if (Loc.y <= Geo.y)
			return M_PI + M_PI / 4.f;

		if (Loc.y > Geo.y && Loc.y < Geo.y + Geo.Height)
			return M_PI;

		if (Loc.y >= Geo.y + Geo.Height)
			return M_PI - M_PI / 4.f;
	}

	if (Loc.x >= Geo.x + Geo.Width) {
		if (Loc.y <= Geo.y)
			return -M_PI / 4.f;

		if (Loc.y > Geo.y && Loc.y < Geo.y + Geo.Height)
			return 0;

		if (Loc.y >= Geo.y + Geo.Height)
			return M_PI / 4.f;
	}

	if (Loc.x > Geo.x && Loc.x < Geo.x + Geo.Width) {
		if (Loc.y <= Geo.y + Geo.Height / 4)
			return -M_PI / 2.f;

		if (Loc.y > Geo.y + Geo.Height / 4)
			return M_PI / 2.f;
	}

	_ERROR_;

	return 0;
}
