/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include <allegro.h>

#include "progress_bar.h"

#include "agl_bitmap.h"
#include <string>


#define FRONT_COLOR_STR std::string("front_color")
#define BACK_COLOR_STR std::string("back_color")
#define PERCENT_STR std::string("percent")


ProgressBar::ProgressBar(const TiXmlElement *Element, const Rect<float> &Parent) :
	ObjectExtension(Element, Parent, false),
	Visible(true) {

	ULONG FrontColor = XMLParser::GetValueUL(Element, FRONT_COLOR_STR, 0xffff00ff);
	ULONG BackColor = XMLParser::GetValueUL(Element, BACK_COLOR_STR, 0xffffff80);

	BITMAP *src_front = create_bitmap_ex(32, 10, 2);
	BITMAP *src_back = create_bitmap_ex(32, 10, 2);

	rectfill(src_front, 0, 0, 10, 2, FrontColor);
	rectfill(src_back, 0, 0, 10, 2, BackColor);

	BarBmp = new AGLBitmap(src_front);
	BackBmp = new AGLBitmap(src_back);

	destroy_bitmap(src_front);
	destroy_bitmap(src_back);

	Percent = XMLParser::GetValueF(Element, PERCENT_STR, 1.f);
}


ProgressBar::~ProgressBar() {
	delete BarBmp;
	delete BackBmp;
}


void ProgressBar::SetPercent(float P) {
	Percent = P;
}


void ProgressBar::Render(const Point<float> &Where, const float &Angle) const {
	if (Visible == false)
		return;

	const Rect<float> Src(0, 0, BarBmp->Dim.Width, BarBmp->Dim.Height);
	const Rect<float> Dst1(Where + static_cast<Point<float> >(Geo), Geo);
	BackBmp->Render(Src, Dst1, Angle);

	const Rect<float> Dst2(Where.x + Geo.x, Where.y + Geo.y, static_cast<USHORT>(Geo.Width * Percent), Geo.Height);
	BarBmp->Render(Src, Dst2, Angle);
}


#endif //SERVER_ONLY
