/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef POLL_H
#define POLL_H

#include "structures.h"
#include <map>


enum POLL_TYPE {POLL_KICK_PLAYER, POLL_CHANGE_MAP};

struct PollResults {
	POLL_TYPE PT;
	USHORT Yes;
	USHORT No;
	int arg;
	std::string argstr;
	bool EndedEarly;
};


class Poll {
public:
	Poll() : Active(false) {};
	void Start(POLL_TYPE PT, int arg, const std::string &argstr, USHORT VotersCount);
	void Reset() {Active = false;}
	void Vote(int CliID, bool val) {SingleVote[CliID] = val;}
	bool Tick();
	void GetResults(PollResults &PR);
	bool Running() {return Active;}

private:
	std::map<int, bool> SingleVote;
	float SecLeft;
	POLL_TYPE PT;
	int arg;
	std::string argstr;
	bool Active;
	USHORT VotersCount;
	bool EndedEarly;
};


#endif
