/***************************************************************************
                          player.h  -  description
                             -------------------
    begin                : Mon Mar 31 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com   
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLAYER_H
#define PLAYER_H


#ifdef WIN32
#include <allegro.h>
#include <winalleg.h>
#endif


#include "controlled_object.h"
#include "player_object.h"

#define PLAYER_STR std::string("player")


class Player : public ControlledObject, public PlayerObject {
public:
	Player(const TiXmlElement *Att, int ClientID);

	OUIDInfo GetObjUID() {return ObjectUID;}

private:
	virtual bool OnKeyDown(const std::set<INPUT_COMMAND> &KeyDown);
	virtual bool OnKeyUp(const std::set<INPUT_COMMAND> &KeyUp);
	virtual void LostControl();

	virtual void Unlink();
};

#endif

