/***************************************************************************
                          physical_object.h  -  description
                             -------------------
    begin                : Sun Oct 26 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PHYSICAL_OBJECT_H
#define PHYSICAL_OBJECT_H

#ifdef WIN32
#include <allegro.h>
#include <winalleg.h>
#endif


#include "mobile_object.h"


extern float Viscosity;

const USHORT LAYER_COUNT(5);


struct IDENTITY {
	OUIDInfo OwnerObjUID;
	int ClientID;
	TEAM Team;
};


struct PMASK;
struct BITMAP;


class PhysicalObject : virtual public MobileObject {
public:
	PhysicalObject(const TiXmlElement *Att, float Scale);
	~PhysicalObject();

	virtual void OnUpdate();
	virtual bool OnCollide(const PhysicalObject *Obj);

	bool AreColliding(PhysicalObject *Obj);

	IDENTITY Identity;

protected:
	bool NextFrame(float TimeElapsed);
	bool NextFrameSingleExtension(const float TimeElapsed);
	virtual void Damage(const PhysicalObject *Obj);
	void DamageFrendly(const PhysicalObject *Obj, const float &FrendlyFire);
	virtual void Unlink();

	std::vector<float> GetExplosionFragmentsAngles(const USHORT FragmentsCount);

	float CollidingEnergy;
	float InnerEnergy;

	Vector<float> CollidingImpulse;

	bool ShapeChanged;
	bool IsFixedShape;
	bool AllowInaccurateCollisionDetection;

	//If true will use somewhat more realistic bouncing, has sideffects
	bool PreventMultipleCollide;

	BITMAP *Shape;
	BITMAP *tmp;

private:
	PMASK *PMaskCache;
	float Elastic;

	PMASK const* GetPMask();
	virtual bool RenderShape() = 0;
	virtual float GetSurfaceNormal(const Point<float> &Loc) const = 0;

	const PhysicalObject *LastObjectCollided;
	bool CollidedLastTime;
	bool CollidingNow;
};

#endif
