/***************************************************************************
 *   Copyright (C) 2003 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef OBJECT_EXTENSION_H
#define OBJECT_EXTENSION_H

#define LAYER_STR std::string("layer")
#define TYPE_STR std::string("type")
#define ENDPOINT_STR std::string("endpoint")

#include <vector>

#ifdef WIN32
#include <allegro.h>
#include <winalleg.h>
#endif

#include "structures.h"
#include "xmlparser.h"


struct BITMAP;
class SoundInfo;


class ObjectExtension {
public:
	ObjectExtension(const TiXmlElement *Element, const Size &Parent, bool SrvMode) :
		Geo(XMLParser::GetValueF(Element, X_STR, 0.f) * Parent.Width / 100.f,
			XMLParser::GetValueF(Element, Y_STR, 0.f) * Parent.Height / 100.f,
			XMLParser::GetValueL(Element, W_STR, 100) * Parent.Width / 100,
			XMLParser::GetValueL(Element, H_STR, 100) * Parent.Height / 100),
		ServerMode(SrvMode),
		Layer(XMLParser::GetValueL(Element, LAYER_STR, 0)) {if (SrvMode) ReadEndpoints(Element, Parent);}
	virtual ~ObjectExtension() {};

	virtual void Reset() {}
#ifndef SERVER_ONLY
	virtual void Render(const Point<float> &Where, const float &Angle) const = 0;
#endif //SERVER_ONLY
	virtual void RenderShape(BITMAP *Dest, BITMAP *tmp) = 0;
	virtual void Update() = 0;
	virtual bool NeedsUpdate(float TimeElapsed) = 0;

	USHORT GetLayer() const {return Layer;}

	virtual const std::vector<Vector<float> >* GetEndpoints() const {return &EndpointList;}
	void ReadEndpoints(const TiXmlElement *Element, const Size &Parent) {
			const TiXmlElementList* Child = XMLParser::GetAllChildren(Element, ENDPOINT_STR);
			EndpointList.reserve(EndpointList.size() + Child->size());
			for (USHORT x = 0; x < Child->size(); ++x) {
				const TiXmlElement *One = Child->at(x);
				EndpointList.push_back(Vector<float>(XMLParser::GetValueF(One, X_STR, 0.f) * Parent.Width / 100.f,
													 XMLParser::GetValueF(One, Y_STR, 0.f) * Parent.Height / 100.f));
			}
			delete Child;
	}

protected:
	Rect<float> Geo;
	bool ServerMode;

private:
	USHORT Layer;
	std::vector<Vector<float> > EndpointList;
};

#endif
