/***************************************************************************
                          object.h  -  description
                             -------------------
    begin                : Sat Mar 22 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OBJECT_H
#define OBJECT_H

#include <vector>

#include "xmlparser.h"
#include "structures.h"
#include "message_coder.h"

#define OBJECT_STR std::string("object")

class Sprite;
class StaticalSprite;
class ObjectExtension;


/* Object - base class of all server-side game objects
    - handles (un)registration to the NetworkServer
    - loads default extensions
    - handles object dimentios and location
    - handles basic object/camera/map geometry
    - destroys extions upon destroing
*/
class Object {
public:
	Object(const TiXmlElement *Att, float Scale);
	virtual ~Object();

	virtual void OnUpdate();
	virtual const ULONG GetTypeID() const = 0;
	virtual void Unlink();

	virtual void CheckData() {};
	virtual void GetCompleteData(MessageCoder &MC) const;
	virtual void GetChangedData(MessageCoder &) const {};
	void GetEmptyData(MessageCoder &MC) const;

	virtual bool IsInsideCamera(const Rect<float> &Camera) const;

	inline const Rect<float>& GetGeo() const {return Geo;}

	inline void SetArenaSize(const Size AS) {ArenaSize = AS;}

	inline void SetLoc(const Point<float> New) {Geo = New;}
	inline void SetLocC(const Point<float> New) {Geo = New - Point<float>(Geo.Width / 2, Geo.Height / 2);}

protected:
	Rect<float> Geo;
	Size ArenaSize;
	OUIDInfo ObjectUID;

	XMLParser *Parser;

	void ResetExtensions();
	std::vector<ObjectExtension*> Extension;

	Sprite* GetBaseSprite(const TiXmlElement *Root);
	StaticalSprite* GetBaseBitmap(const TiXmlElement *Root);

	FullObjInfo FOIPartial;

private:
	inline bool IsOut() {
		return (Geo.x + Geo.Width > ArenaSize.Width || Geo.x < 0 ||
			Geo.y + Geo.Height > ArenaSize.Height || Geo.y < 0);
	}
	virtual void OnArenaOut();

	inline Point<float> GetRenderLoc(const Rect<float> &Camera) const;

	void LoadExtensions();
};

#endif
