/***************************************************************************
                          object.cpp  -  description
                             -------------------
    begin                : Sat Mar 22 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sprite.h"
#include "statical_sprite.h"
#include "network_server.h"

#include "object.h"
#include "initializer.h"
//#include "text.h"

#include "sparklet_utils.h"

#define BASE_SPRITE_STR std::string("base_sprite")
#define BASE_BITMAP_STR std::string("base_bitmap")
#define SURFACE_STR std::string("surface")


extern NetworkServer *gNetworkServer;

using namespace std;


Object::Object(const TiXmlElement *Att, float Scale) {
	Geo.x = XMLParser::GetValueL(Att, X_STR, 10);
	Geo.y = XMLParser::GetValueL(Att, Y_STR, 10);

	const string RelPath = FixFilenameSlashes(XMLParser::GetValueS(Att, SOURCE_STR, ""));
	const string ObjFilePath = string(DATA_PREFIX) + RelPath;

	auto_ptr<XMLParser> apParser(new XMLParser(ObjFilePath));
	Parser = apParser.get();

	const TiXmlElement *Root = Parser->GetRoot();

	Geo.Width = XMLParser::GetValueL(Root, W_STR, 1);
	Geo.Height = XMLParser::GetValueL(Root, H_STR, 1);
	Geo.Width = XMLParser::GetValueL(Att, W_STR, Geo.Width);
	Geo.Height = XMLParser::GetValueL(Att, H_STR, Geo.Height);

	Geo.Width = static_cast<USHORT>(sqrt(Scale * Geo.Width * Geo.Width));
	Geo.Height = static_cast<USHORT>(sqrt(Scale * Geo.Height * Geo.Height));

	LoadExtensions();

	FOIPartial.XMLFilePathCode = gNetworkServer->GetCodeFromPath(RelPath);
	FOIPartial.Surface = XMLParser::GetValueL(Att, SURFACE_STR, 0);
	FOIPartial.Scale = Scale;

	apParser.release();
	ObjectUID = gNetworkServer->Add(this);
}


void Object::LoadExtensions() {
	const TiXmlElement *Root = Parser->GetRoot();

	const TiXmlElementList* Child = Parser->GetAllChildren(Root, SPRITE_STR);
	for (USHORT x = 0; x < Child->size(); ++x) {
		Extension.push_back(new Sprite(Child->at(x), Geo, true));
	}
	delete Child;

	Child = Parser->GetAllChildren(Root, STATICAL_SPRITE_STR);
	for (USHORT x = 0; x < Child->size(); ++x) {
		Extension.push_back(new StaticalSprite(Child->at(x), Geo, true));
	}
	delete Child;

	//disabled because there is usally no text on server side
	/*Child = Parser->GetAllChildren(Root, TEXT_STR);
	for (USHORT x = 0; x < Child->size(); ++x) {
		Extension.push_back(new Text(Child->at(x), Geo));
	}
	delete Child;*/
}


Object::~Object() {
	while (!Extension.empty()) {
		delete Extension.back();
		Extension.pop_back();
	}

	delete Parser;
}


void Object::OnUpdate() {
	if (IsOut())
		OnArenaOut();
}


void Object::GetCompleteData(MessageCoder &MC) const {
	FullObjInfo *FOI = new FullObjInfo();
	*FOI = FOIPartial;
	FOI->Dim = Geo;
	MC.Put(FOI);
}


void Object::GetEmptyData(MessageCoder &MC) const {
	MC.PutRemove(ObjectUID);
}


void Object::OnArenaOut() {
	Unlink();
}


void Object::Unlink() {
	gNetworkServer->RemoveObject(ObjectUID);
}


Sprite* Object::GetBaseSprite(const TiXmlElement *Root) {
	const TiXmlElement *Element = Parser->GetChild(Root, BASE_SPRITE_STR);
	Sprite *BaseSprite = new Sprite(Element, Geo, true);
	Extension.push_back(BaseSprite);

	return BaseSprite;
}


StaticalSprite* Object::GetBaseBitmap(const TiXmlElement *Root) {
	const TiXmlElement *Element = Parser->GetChild(Root, BASE_BITMAP_STR);
	StaticalSprite *BaseBitmap = new StaticalSprite(Element, Geo, true);
	Extension.push_back(BaseBitmap);

	return BaseBitmap;
}


void Object::ResetExtensions() {
	for (USHORT x = 0; x < Extension.size(); ++x)
		Extension[x]->Reset();
}


inline Point<float> Object::GetRenderLoc(const Rect<float> &Camera) const {
	return Point<float>(Geo.x - Camera.x + Camera.Width / 2, Geo.y - Camera.y + Camera.Height / 2);
}


bool Object::IsInsideCamera(const Rect<float> &Camera) const {
	const Point<float> &RendLoc = GetRenderLoc(Camera);

	return !(RendLoc.x + Geo.Width <= 0 || RendLoc.x >= Camera.Width) &&
		!(RendLoc.y + Geo.Height <= 0 || RendLoc.y >= Camera.Height);
}
