/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef MESSAGE_WRITER_H
#define MESSAGE_WRITER_H


#include "text.h"
#include "gui_object.h"
#include "initializer.h"

#include <vector>

#define MESSAGE_WRITER_STR std::string("message_writer")


class MessageWriter : public GuiObject {
public:
	MessageWriter(const TiXmlElement *Att, const Size &Dim, float Scale);

	void PutChar(char c);
	void PopChar();
	void Clear() {Line->SetText("|");}

	void HistoryBackward();
	void HistoryForward();
	void HistoryPush();

	const std::string GetText() const {return Line->GetText().substr(0, Line->GetText().length() - 1);}
	inline const bool GetVisible() const {return Visible;}

private:
	Text *Line;
	USHORT CurrentHistoryLine;
	std::vector<std::string> HistoryLine;
};

DECLARE_CLI_FACTORY(MessageWriter, CliObject)

#endif

#endif //SERVER_ONLY
