/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Fri Feb 21 22:37:36 CET 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <allegro.h>

#ifdef WIN32
	#include <winalleg.h>
#endif

#include "game.h"
#include "structures.h"

#include <string>
#include <iostream>


LoggingConsole *gLC;


void DisplayHelp() {
	std::cout << "Sparkelt - " SPARKLET_VERSION_STR << std::endl;
	std::cout << "Written by Milan Mimica (milan.mimica@gmail.com)" << std::endl;
	std::cout << "beta-testing Ivan Radolovic" << std::endl;
	std::cout << std::endl;
	std::cout << "-v, --version     display version number and exit" << std::endl;
	std::cout << "-h, --help        display this message and exit" << std::endl;
#ifdef WIN32
	std::cout << "-l, --logfile     specify path to logfile (default is sparklet.log)" << std::endl;
#else
	#ifdef SERVER_ONLY
		std::cout << "-p, --profile     specify path to profile file (default is data/profile.ini)" << std::endl;
		std::cout << "-l, --logfile     specify path to logfile (default is sparklet.log)" << std::endl;
		std::cout << "-b, --background  run server in background" << std::endl;
	#else
		std::cout << "-l, --logfile     specify path to logfile (default is stdout)" << std::endl;
	#endif
#endif
	std::cout << "-n, --net-debug   specify networking debug messages level (0 to 7)" << std::endl;
	std::cout << std::endl;
	std::cout << "This program is free software; you can redistribute it and/or modify it under" << std::endl;
	std::cout << "the terms of the GNU General Public License as published by the Free Software" << std::endl;
	std::cout << "Foundation; either version 2 of the License, or (at your option) any later version" << std::endl;
	std::cout << std::endl;
	std::cout << "http://sparklet.sf.net" << std::endl;
}


void DisplayVersion() {
	std::cout << "Sparkelt - " SPARKLET_VERSION_STR << std::endl;
}


void GetCommandLineOptions(int argc, char **argv, std::string &ProfilePath, std::string &LogPath, int &NetDebugLevel, bool &RunInBackground) {
	NetDebugLevel = 3;
	ProfilePath = "data/profile.ini";
	RunInBackground = false;
#if defined(SERVER_ONLY) || defined(WIN32)
	LogPath = "sparklet.log";
#else
	LogPath = "stdout"; //special value, redirect log to stdout
#endif

	for (int x = 1; x < argc; ++x) {
		const char *arg = argv[x];

		if (arg[0] != '-')
			continue;

		if (!strcmp(arg, "--help") || !strcmp(arg, "-h")) {
			DisplayHelp();
			exit(EXIT_SUCCESS);
		} else if (!strcmp(arg, "--version") || !strcmp(arg, "-v")) {
			DisplayVersion();
			exit(EXIT_SUCCESS);
		}
#ifdef SERVER_ONLY
		else if (!strcmp(arg, "--profile") || !strcmp(arg, "-p")) {
			++x;
			if (argc <= x) {
				DisplayHelp();
				exit(EXIT_SUCCESS);
			}

			ProfilePath = argv[x];
			if (!exists(ProfilePath.c_str())) {
				std::cout << "File '" + ProfilePath + "' doesn't exist!" << std::endl;
				std::cout << "Type 'sparklet --help' for more info." << std::endl;
				exit(EXIT_SUCCESS);
			}
		}
		else if (!strcmp(arg, "-b") || !strcmp(arg, "--background")) {
			RunInBackground = true;
		}
#endif
		else if (!strcmp(arg, "--logfile") || !strcmp(arg, "-l")) {
			++x;
			if (argc <= x) {
				DisplayHelp();
				exit(EXIT_SUCCESS);
			}

			LogPath = argv[x];
		} else if (!strcmp(arg, "--net-debug") || !strcmp(arg, "-n")) {
			++x;
			if (argc <= x) {
				DisplayHelp();
				exit(EXIT_SUCCESS);
			}

			NetDebugLevel = atoi(argv[x]);
			if (NetDebugLevel < 0 || NetDebugLevel > 7) {
				std::cout << "Net debug level must be between 0 and 7 inclusive!" << std::endl;
				exit(EXIT_SUCCESS);
			}
		} else {
			std::cout << "Unknown option: '" << argv[x] << "'." << std::endl;
			exit(EXIT_SUCCESS);
		}
	}
}

#ifdef WIN32
const char *strchrnul(const char *string, char c) {
	const char *ret = strchr(string, c);
	if (ret)
		return ret;
	else
		return &string[strlen(string)];
}
#endif


int main(int argc, char **argv) {
	int NetDebugLevel;
	bool RunInBackground;
	std::string ProfileFilePath;
	std::string LogFilePath;
	GetCommandLineOptions(argc, argv, ProfileFilePath, LogFilePath, NetDebugLevel, RunInBackground);

	//construct the filename of the second file
	std::string SecondFile = LogFilePath;
	std::string SecondFileExt;
	//get file externsion
	SecondFileExt.assign(strchrnul(SecondFile.c_str(), '.'));
	//strip file extension
	SecondFile.resize(SecondFile.length() - SecondFileExt.length() - 1);
	//reassemble the filename
	if (SecondFileExt.length())
		SecondFile += "-2." + SecondFileExt;
	else
		SecondFile += "-2";

	//init global logging console
#ifdef WIN32
	//on windows log to file
	gLC = new LoggingConsole(LogFilePath, SecondFile, 0xfffff);
#else
	if (LogFilePath == "stdout")
		gLC = new LoggingConsole();
	else
		gLC = new LoggingConsole(LogFilePath, SecondFile, 0xfffff);
#endif

	gLC->set_xprintf_level(7 - NetDebugLevel);

	//init allegro
#ifdef SERVER_ONLY
	if (install_allegro(SYSTEM_NONE, &errno, atexit) != 0) {
#else
	if (allegro_init() != 0) {
#endif
		_ERROR_;
		_SAY("Couldn't init allegro!");

		delete gLC;

		return -1;
	}

	if (exists(SERVER_LIST_FILE_NAME)) {
	//remove the list of servers
		if (remove(SERVER_LIST_FILE_NAME)) {
			_ERROR_;
			_SAY("Could not remove list of game servers.");
		}
	}

	srand(time(NULL));

	{
		Game TheGame;
	#ifndef SERVER_ONLY
		if (!TheGame.Start())
	#else
		if (!TheGame.StartServerOnly(ProfileFilePath, RunInBackground))
	#endif //SERVER_ONLY
		{
			_ERROR_;
			_SAY("Abnormal, yet clean, game termination!");
		}
	}

	delete gLC;

	return 0;
}

END_OF_MAIN()
