/***************************************************************************
                          initializer.cpp  -  description
                             -------------------
    begin                : Sat Oct 25 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "player.h"
#include "factoryes.h"

#include "network_messages.h"


using namespace std;


Initializer::~Initializer() {
	for (map<const string, ObjectFactory*>::iterator x = ObjectFactoryes.begin(); x != ObjectFactoryes.end(); ++x)
		delete x->second;

#ifndef SERVER_ONLY
	for (map<const string, CliObjectFactory*>::iterator x = CliObjectFactoryes.begin(); x != CliObjectFactoryes.end(); ++x)
		delete x->second;
#endif //SERVER_ONLY
}


Object* Initializer::CreateObject(const TiXmlElement *Element, float Scale) {
	if (ObjectFactoryes.find(XMLParser::GetName(Element)) == ObjectFactoryes.end())
		return NULL;

	return (*ObjectFactoryes[XMLParser::GetName(Element)])(Element, Scale);
}


#ifndef SERVER_ONLY
CliObject* Initializer::CreateCliObject(const TiXmlElement *Element, const Size &Dim, float Scale) {
	if (CliObjectFactoryes.find(XMLParser::GetName(Element)) == CliObjectFactoryes.end()) {
		_ERROR_;
		_DISPLAY(XMLParser::GetName(Element));
		return NULL;
	}

	return (*CliObjectFactoryes[XMLParser::GetName(Element)])(Element, Dim, Scale);
}
#endif //SERVER_ONLY
