/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include <alleggl.h>
#undef MessageBox

#include "gui_server_options.h"
#include "game_gui.h"
#include "network_server.h"

using namespace MAS;

extern float gTimeElapsed;


GUIServerOptions::GUIServerOptions(NetworkServer *srv) :
	Window(),
	Server(srv) {

	title.SetText("Start server");
	ClearFlag(D_RESIZABLE);
	MAS::Window::Centre();

	Shape(250, 50, 500, 580);

	bStart.Shape(25, 95, 20, 4, true);
	bStart.SetText("START");
	bCancel.Shape(55, 95, 20, 4, true);
	bCancel.SetText("CANCEL");

	gMapSelectorPanel.Setup(5, 5, 480, 240, 0, 0);
	gMapSelectorPanel.SetTitle("map selector");

	MapSel.Shape(15, 30, 470, 250);

	ePort.Setup(120, 265, 50, 25, 0, 0, get_config_string("server", "port", "2020"), 5);
	sMaxPlayers.Setup(120, 290, 50, 25, 0, 0, (int)1, (int)30, (int)0, (int)1);
	sMaxPlayers.editBox.SetText(get_config_string("server", "max_players", "10"), 2);
	sTimeOut.Setup(120, 315, 50, 25, 0, 0, (int)5, (int)60, 0, (int)1);
	sTimeOut.editBox.SetText(get_config_string("server", "client_timeout", "8"), 2);

	lPort.Setup(10, 272, 40, 20, 0, 0, "port number:");
	lMaxPlayers.Setup(10, 297, 60, 20, 0, 0, "max. players:");
	lTimeOut.Setup(10, 322, 45, 20, 0, 0, "client timeout:");

	eMsg.Setup(200, 270, 270, 20, 0, 0, get_config_string("server", "msg", ""));
	eName.Setup(300, 290, 170, 20, 0, 0, get_config_string("server", "name", ""), 15);
	ePassword.Setup(300, 310, 170, 20, 0, 0, "", 15);

	lMsg.Setup(203, 257, 270, 20, 0, 0, "welcome message sent on connection");
	lName.Setup(203, 297, 40, 20, 0, 0, "server name:");
	lPassword.Setup(203, 317, 20, 20, 0, 0, "password:");

	cGameType.Setup(120, 340, 160, 25, 0, 0, 0);
	cGameType.list.InsertItem(new ListItemString("DEATH MATCH"), 0);
	cGameType.list.InsertItem(new ListItemString("TEAM DEATH MATCH"), 1);
	cGameType.list.Select(get_config_int("server", "game_type", 0));
	lGameType.Setup(10, 347, 40, 20, 0, 0, "game rules:");

	sMaxPoints.Setup(120, 365, 50, 25, 0, 0, (int)1, (int)120, (int)0, (int)1);
	sMaxPoints.editBox.SetText(get_config_string("server", "max_points", "20"), 3);
	lMaxPoints.Setup(10, 372, 40, 20, 0, 0, "max. points:");

	sFrendlyFire.Setup(300, 365, 40, 25, 0, 0, 0, 100, get_config_int("server", "frendly_fire", 20), 1);
	lFrendlyFire.Setup(200, 372, 40, 20, 0, 0, "frendly fire %:");

	sNetRatio.Setup(10, 395, 40, 25, 0, 0, (int)1, (int)10, get_config_int("server", "net_ratio", 3), (int)1);
	lNetRatio.Setup(60, 395, 430, 20, 0, 0, "tick - net ratio: USE WITH CAUTION!\n"
		"Decreasing this value will increase network traffic (especially server's upload and "
		"client's download) but also improve game accuracy (less twiches). Vice versa applyes "
		"too. Traffic - accuracy dependency is nearly linear. Default setting is 3.");
	lNetRatio.SetWordWrap(true);
	lNetRatio.SetTooltipText("test");

	cCompression.Setup(10, 470, 250, 20, 0, get_config_int("server", "compress", 0) ? D_SELECTED : 0, "Compress outgoing packets");
	cReliable.Setup(10, 490, 455, 20, 0, get_config_int("server", "reliable", 1) ? D_SELECTED : 0, "Improve game accuracy on poor networks. Not necessary for LAN playing.");

	Add(bStart);
	Add(bCancel);

	Add(gMapSelectorPanel);

	Add(ePort);
	Add(sMaxPlayers);
	Add(eName);
	Add(eMsg);
	Add(ePassword);

	Add(sTimeOut);
	Add(cGameType);
	Add(sMaxPoints);
	Add(sNetRatio);
	Add(cCompression);
	Add(cReliable);
	Add(sFrendlyFire);

	Add(lPort);
	Add(lMaxPlayers);
	Add(lTimeOut);
	Add(lName);
	Add(lMsg);
	Add(lPassword);
	Add(lGameType);
	Add(lNetRatio);
	Add(lMaxPoints);
	Add(lFrendlyFire);

	Add(MapSel);
}

#include "exceptions.h"

void GUIServerOptions::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Window::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
			if (obj == bCancel) {
				Close();
			}
			else if (obj == bStart) {
				ServerOptions SO;
				SO.MaxClients = atoi(sMaxPlayers.editBox.GetText());
				SO.WelcomeMessage = eMsg.GetText();
				SO.Name = eName.GetText();
				SO.Password = ePassword.GetText();
				SO.Port = atoi(ePort.GetText());
				SO.Tick = gTimeElapsed;
				SO.NetRatio = atoi(sNetRatio.editBox.GetText());
				SO.ClientTimeout = atoi(sTimeOut.editBox.GetText());
				SO.ReliableDeltaPackets = cReliable.TestFlag(D_SELECTED);
				if (cCompression.TestFlag(D_SELECTED))
					//smaller packets are just not worth compressing
					SO.MinPacketCompressSize = 250;
				else
					SO.MinPacketCompressSize = -1;

				GameOptions GO;
				GO.GT = static_cast<GAME_TYPE>(cGameType.list.Selection());
				GO.FrendlyFire = atoi(sFrendlyFire.editBox.GetText());
				GO.PointsMax = atoi(sMaxPoints.editBox.GetText());
				GO.MapFileNameList = MapSel.GetMapPathList();

				if (Server->Start(SO, GO)) {
					SaveSettings();
					Dialog *GG = Widget::GetParent();
					GG->HandleEvent(*this, MSG_SERVER_STARTED_MSGB);
					Close();
				}
				else {
					Dialog *GG = Widget::GetParent();
					GG->HandleEvent(*this, MSG_SERVER_ERROR_MSGB);
				}
			}
		break;
	}
}


void GUIServerOptions::SaveSettings() {
	set_config_string("server", "port", ePort.GetText());
	set_config_string("server", "max_players", sMaxPlayers.editBox.GetText());
	set_config_string("server", "max_points", sMaxPoints.editBox.GetText());
	set_config_string("server", "client_timeout", sTimeOut.editBox.GetText());
	set_config_string("server", "frendly_fire", sFrendlyFire.editBox.GetText());
	set_config_string("server", "msg", eMsg.GetText());
	set_config_string("server", "name", eName.GetText());
	set_config_string("server", "net_ratio", sNetRatio.editBox.GetText());
	set_config_int("server", "compress", cCompression.TestFlag(D_SELECTED) ? 1 : 0);
	set_config_int("server", "reliable", cReliable.TestFlag(D_SELECTED) ? 1 : 0);
	set_config_int("server", "game_type", cGameType.list.Selection());

	MapSel.SaveSettings();
}


#endif //SERVER_ONLY
