/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY

#ifndef GUI_MESSAGE_BOX_H
#define GUI_MESSAGE_BOX_H

#include <MASkinG.h>

#undef MessageBox

/*
Nonblocking MAS::MessageBox

Wrapper around MAS::MessageBox so it can be added dynamically do the dialog,
using Dialog::Add() and Dialog::Remove().
*/

class GUIMessageBox : public MAS::MessageBox {
public:
	GUIMessageBox(MAS::Dialog *p,
		const char* t = "Message",
		const char* l1 = "This is a message.",
		const char* l2 = NULL,
		const char* l3 = NULL,
		const char* b1 = "OK",
		const char* b2 = NULL,
		const char* b3 = NULL) :
		MAS::MessageBox(t, l1, l2, l3, b1, b2, b3) {

		SetParent(p);
		CalculateGeometry();
		Centre();
	}


	int GetAnswer() {
		if (MAS::Window::GetFocusObject() == &button1)
			return 0;
		if (MAS::Window::GetFocusObject() == &button2)
			return 1;
		if (MAS::Window::GetFocusObject() == &button3)
			return 2;

		return 3;
	}
};

#endif

#endif //SERVER_ONLY

