/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include <alleggl.h>

#include "gui_game_options.h"
#include "game_gui.h"
#include "game_input.h"
#include "sparklet_utils.h"


using namespace MAS;


KeyConfigurator::KeyConfigurator() :
	Dialog() {

	gKeysPanel.Setup(5, 5, 455, 410, 0, 0);
	gKeysPanel.SetTitle("keyboard");
	lPriKey.Setup(150, 25, 40, 20, 0, 0, "primary key");
	lSecKey.Setup(255, 25, 40, 20, 0, 0, "secondary key");

	for (int i = 0; i < KEY_COUNT; ++i) {
		lKeyFunction[i].Setup(15, 45 + i * 20, 40, 20, 0, 0, "");
		for (int c = KEY_MAX - 1; c >= 0; --c) {
			cPriKey[i].list.InsertItem(new ListItemString(scancode_to_name(c)), 0);
			cSecKey[i].list.InsertItem(new ListItemString(scancode_to_name(c)), 0);
		}
		cPriKey[i].Setup(145, 40 + i * 20, 100, 20, 0, 0, 255);
		cSecKey[i].Setup(255, 40 + i * 20, 100, 20, 0, 0, 255);
	}

	lKeyFunction[0].SetText("move forward:");
	lKeyFunction[1].SetText("move backward:");
	lKeyFunction[2].SetText("turn left:");
	lKeyFunction[3].SetText("turn right:");
	lKeyFunction[4].SetText("strafe left:");
	lKeyFunction[5].SetText("strafe right:");
	lKeyFunction[6].SetText("zoom in:");
	lKeyFunction[7].SetText("zoom out:");
	lKeyFunction[8].SetText("primary fire:");
	lKeyFunction[9].SetText("secondary fire:");
	lKeyFunction[10].SetText("change weapon:");
	lKeyFunction[11].SetText("machinegun:");
	lKeyFunction[12].SetText("cannon:");
	lKeyFunction[13].SetText("fuzzygun:");
	lKeyFunction[14].SetText("integral:");
	lKeyFunction[15].SetText("derivator:");
	lKeyFunction[16].SetText("torpedo:");
	lKeyFunction[17].SetText("bouncer:");

	LoadKeys();
	SetKeys();

	Add(gKeysPanel);
	Add(lPriKey);
	Add(lSecKey);
	for (int i = 0; i < KEY_COUNT; ++i) {
		Add(lKeyFunction[i]);
		Add(cPriKey[i]);
		Add(cSecKey[i]);
	}
}


void KeyConfigurator::SetKeys() {
	GameInput::CommandDecoder.clear();
	GameInput::CommandDecoder.insert(std::make_pair(static_cast<int>(KEY_ESC), IC_SWITCH_DISPLAY));
	GameInput::CommandDecoder.insert(std::make_pair(static_cast<int>(KEY_F1), IC_SWITCH_SCORE_TABLE_DISPLAY));
	GameInput::CommandDecoder.insert(std::make_pair(static_cast<int>(KEY_F2), IC_SWITCH_MESSAGE_WRITER));
	GameInput::CommandDecoder.insert(std::make_pair(static_cast<int>(KEY_F3), IC_SWITCH_STATISTICS));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[0].list.Selection(), IC_POWER_UP));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[0].list.Selection(), IC_POWER_UP));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[1].list.Selection(), IC_MOVE_BACKWARD));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[1].list.Selection(), IC_MOVE_BACKWARD));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[2].list.Selection(), IC_TURN_LEFT));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[2].list.Selection(), IC_TURN_LEFT));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[3].list.Selection(), IC_TURN_RIGHT));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[3].list.Selection(), IC_TURN_RIGHT));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[4].list.Selection(), IC_STRAFE_LEFT));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[4].list.Selection(), IC_STRAFE_LEFT));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[5].list.Selection(), IC_STRAFE_RIGHT));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[5].list.Selection(), IC_STRAFE_RIGHT));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[6].list.Selection(), IC_ZOOM_IN));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[6].list.Selection(), IC_ZOOM_IN));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[7].list.Selection(), IC_ZOOM_OUT));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[7].list.Selection(), IC_ZOOM_OUT));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[8].list.Selection(), IC_PRIMARY_FIRE));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[8].list.Selection(), IC_PRIMARY_FIRE));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[9].list.Selection(), IC_SECONDARY_FIRE));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[9].list.Selection(), IC_SECONDARY_FIRE));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[10].list.Selection(), IC_CHANGE_WEAPON));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[10].list.Selection(), IC_CHANGE_WEAPON));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[11].list.Selection(), IC_SELECT_MACHINEGUN));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[11].list.Selection(), IC_SELECT_MACHINEGUN));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[12].list.Selection(), IC_SELECT_CANNON));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[12].list.Selection(), IC_SELECT_CANNON));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[13].list.Selection(), IC_SELECT_FUZZYGUN));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[13].list.Selection(), IC_SELECT_FUZZYGUN));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[14].list.Selection(), IC_SELECT_BOUNCER));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[14].list.Selection(), IC_SELECT_BOUNCER));
	
	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[15].list.Selection(), IC_SELECT_INTEGRAL));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[15].list.Selection(), IC_SELECT_INTEGRAL));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[16].list.Selection(), IC_SELECT_DERIVATOR));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[16].list.Selection(), IC_SELECT_DERIVATOR));

	GameInput::CommandDecoder.insert(std::make_pair(cPriKey[17].list.Selection(), IC_SELECT_TORPEDO));
	GameInput::CommandDecoder.insert(std::make_pair(cSecKey[17].list.Selection(), IC_SELECT_TORPEDO));
}


void KeyConfigurator::LoadKeys() {
	cPriKey[0].list.Select(get_config_int("keys", "power_up_p", 0));
	cSecKey[0].list.Select(get_config_int("keys", "power_up_s", 0));

	cPriKey[1].list.Select(get_config_int("keys", "move_backward_p", 0));
	cSecKey[1].list.Select(get_config_int("keys", "move_backward_s", 0));

	cPriKey[2].list.Select(get_config_int("keys", "turn_left_p", 0));
	cSecKey[2].list.Select(get_config_int("keys", "turn_left_s", 0));

	cPriKey[3].list.Select(get_config_int("keys", "turn_right_p", 0));
	cSecKey[3].list.Select(get_config_int("keys", "turn_right_s", 0));

	cPriKey[4].list.Select(get_config_int("keys", "strafe_left_p", 0));
	cSecKey[4].list.Select(get_config_int("keys", "strafe_left_s", 0));

	cPriKey[5].list.Select(get_config_int("keys", "strafe_right_p", 0));
	cSecKey[5].list.Select(get_config_int("keys", "strafe_right_s", 0));

	cPriKey[6].list.Select(get_config_int("keys", "zoom_in_p", 0));
	cSecKey[6].list.Select(get_config_int("keys", "zoom_in_s", 0));

	cPriKey[7].list.Select(get_config_int("keys", "zoom_out_p", 0));
	cSecKey[7].list.Select(get_config_int("keys", "zoom_out_s", 0));

	cPriKey[8].list.Select(get_config_int("keys", "primary_fire_p", 0));
	cSecKey[8].list.Select(get_config_int("keys", "primary_fire_s", 0));

	cPriKey[9].list.Select(get_config_int("keys", "secondary_fire_p", 0));
	cSecKey[9].list.Select(get_config_int("keys", "secondary_fire_s", 0));

	cPriKey[10].list.Select(get_config_int("keys", "change_weapon_p", 0));
	cSecKey[10].list.Select(get_config_int("keys", "change_weapon_s", 0));

	cPriKey[11].list.Select(get_config_int("keys", "machinegun_p", 0));
	cSecKey[11].list.Select(get_config_int("keys", "machinegun_s", 0));

	cPriKey[12].list.Select(get_config_int("keys", "cannon_p", 0));
	cSecKey[12].list.Select(get_config_int("keys", "cannon_s", 0));

	cPriKey[13].list.Select(get_config_int("keys", "fuzzygun_p", 0));
	cSecKey[13].list.Select(get_config_int("keys", "fuzzygun_s", 0));

	cPriKey[14].list.Select(get_config_int("keys", "bouncer_p", 0));
	cSecKey[14].list.Select(get_config_int("keys", "bouncer_s", 0));
	
	cPriKey[15].list.Select(get_config_int("keys", "integral_p", 0));
	cSecKey[15].list.Select(get_config_int("keys", "integral_s", 0));

	cPriKey[16].list.Select(get_config_int("keys", "derivator_p", 0));
	cSecKey[16].list.Select(get_config_int("keys", "derivator_s", 0));

	cPriKey[17].list.Select(get_config_int("keys", "torpedo_p", 0));
	cSecKey[17].list.Select(get_config_int("keys", "torpedo_s", 0));
}


void KeyConfigurator::SaveKeys() {
	set_config_int("keys", "power_up_p", cPriKey[0].list.Selection());
	set_config_int("keys", "power_up_s", cSecKey[0].list.Selection());

	set_config_int("keys", "move_backward_p", cPriKey[1].list.Selection());
	set_config_int("keys", "move_backward_s", cSecKey[1].list.Selection());

	set_config_int("keys", "turn_left_p", cPriKey[2].list.Selection());
	set_config_int("keys", "turn_left_s", cSecKey[2].list.Selection());

	set_config_int("keys", "turn_right_p", cPriKey[3].list.Selection());
	set_config_int("keys", "turn_right_s", cSecKey[3].list.Selection());

	set_config_int("keys", "strafe_left_p", cPriKey[4].list.Selection());
	set_config_int("keys", "strafe_left_s", cSecKey[4].list.Selection());

	set_config_int("keys", "strafe_right_p", cPriKey[5].list.Selection());
	set_config_int("keys", "strafe_right_s", cSecKey[5].list.Selection());

	set_config_int("keys", "zoom_in_p", cPriKey[6].list.Selection());
	set_config_int("keys", "zoom_in_s", cSecKey[6].list.Selection());

	set_config_int("keys", "zoom_out_p", cPriKey[7].list.Selection());
	set_config_int("keys", "zoom_out_s", cSecKey[7].list.Selection());

	set_config_int("keys", "primary_fire_p", cPriKey[8].list.Selection());
	set_config_int("keys", "primary_fire_s", cSecKey[8].list.Selection());

	set_config_int("keys", "secondary_fire_p", cPriKey[9].list.Selection());
	set_config_int("keys", "secondary_fire_s", cSecKey[9].list.Selection());

	set_config_int("keys", "change_weapon_p", cPriKey[10].list.Selection());
	set_config_int("keys", "change_weapon_s", cSecKey[10].list.Selection());

	set_config_int("keys", "machinegun_p", cPriKey[11].list.Selection());
	set_config_int("keys", "machinegun_s", cSecKey[11].list.Selection());

	set_config_int("keys", "cannon_p", cPriKey[12].list.Selection());
	set_config_int("keys", "cannon_s", cSecKey[12].list.Selection());

	set_config_int("keys", "fuzzygun_p", cPriKey[13].list.Selection());
	set_config_int("keys", "fuzzygun_s", cSecKey[13].list.Selection());

	set_config_int("keys", "bouncer_p", cPriKey[14].list.Selection());
	set_config_int("keys", "bouncer_s", cSecKey[14].list.Selection());
	
	set_config_int("keys", "integral_p", cPriKey[15].list.Selection());
	set_config_int("keys", "integral_s", cSecKey[15].list.Selection());

	set_config_int("keys", "derivator_p", cPriKey[16].list.Selection());
	set_config_int("keys", "derivator_s", cSecKey[16].list.Selection());

	set_config_int("keys", "torpedo_p", cPriKey[17].list.Selection());
	set_config_int("keys", "torpedo_s", cSecKey[17].list.Selection());
}


MiscOptions::MiscOptions() :
	MAS::Dialog() {

	gSoundPanel.Setup(5, 5, 455, 160, 0, 0);
	gSoundPanel.SetTitle("sound");

	lSoundVolume.Setup(100, 30, 100, 20, 0, 0, "Sound volume");
	lSoundVolMin.Setup(15, 46, 40, 20, 0, 0, "min");
	lSoundVolMax.Setup(258, 46, 40, 20, 0, 0, "max");
	slSoundVolume.Setup(45, 45, 200, 15, 0, 0, 0, 30, get_config_int("sound", "volume", 0), 1);

	chGUISound.Setup(315, 45, 100, 20, 0, get_config_int("sound", "gui_sounds", 0) ? D_SELECTED : 0, "GUI sounds");
	chHardwareMixer.Setup(315, 65, 140, 20, 0, get_config_int("sound", "hardware_mixer", 0) ? D_SELECTED : 0, "hardware mixer");

	lMixerQuality.Setup(100, 75, 100, 20, 0, 0, "Sound quality");
	lMixerQuaMin.Setup(15, 91, 40, 20, 0, 0, "min");
	lMixerQuaMax.Setup(258, 91, 40, 20, 0, 0, "max");
	slMixerQuality.Setup(45, 90, 200, 15, 0, 0, 0, 2, get_config_int("sound", "quality", 1), 1);

	lSoundDriver.Setup(15, 127, 60, 20, 0, 0, "Sound driver:");
	cSoundDriver.Setup(115, 125, 165, 20, 0, 0, 0);
	FillWithSoundDrivers(cSoundDriver);

	SetSounds();

	gGraphicsPanel.Setup(5, 170, 455, 50, 0, 0);
	gGraphicsPanel.SetTitle("graphics");
	cResolution.Setup(115, 190, 100, 20, 0, 0, 0);

	FillWithGfxModes(cResolution);
	lResolution.Setup(15, 197, 40, 20, 0, 0, "resolution:");
	chWindowed.Setup(315, 195, 100, 20, 0, get_config_int("graphics", "windowed", 0) ? D_SELECTED : 0, "windowed");

	Add(gSoundPanel);
	Add(gGraphicsPanel);

	Add(lSoundVolume);
	Add(lSoundVolMin);
	Add(lSoundVolMax);
	Add(slSoundVolume);

	Add(lMixerQuality);
	Add(lMixerQuaMin);
	Add(lMixerQuaMax);
	Add(slMixerQuality);

	Add(chGUISound);
	Add(chHardwareMixer);

	Add(lSoundDriver);
	Add(cSoundDriver);

	Add(cResolution);
	Add(lResolution);
	Add(chWindowed);
}


void MiscOptions::SetSounds() {
	int SoundVolume = (int)(255 * (slSoundVolume.GetPosition() / slSoundVolume.GetRange()));
	Settings::guiSound = chGUISound.TestFlag(D_SELECTED);
	Settings::soundVolume = SoundVolume;

	set_mixer_quality((int)slMixerQuality.GetPosition());

	if (chHardwareMixer.TestFlag(D_SELECTED)) {
		set_hardware_volume(SoundVolume, 0);
		set_volume(255, 0);
	}
	else
		set_volume(SoundVolume, 0);
}


void MiscOptions::SaveSounds(Dialog *Parent) {
	set_config_int("sound", "volume", (int)slSoundVolume.GetPosition());
	set_config_int("sound", "quality", (int)slMixerQuality.GetPosition());
	set_config_int("sound", "gui_sounds", chGUISound.TestFlag(D_SELECTED) ? 1 : 0);
	set_config_int("sound", "hardware_mixer", chHardwareMixer.TestFlag(D_SELECTED) ? 1 : 0);

	if (get_config_int("sound", "driver", 0) != cSoundDriver.list.Selection()) {
		set_config_int("sound", "driver", cSoundDriver.list.Selection());

		Parent->HandleEvent(*this, MSG_SOUND_DRIVER_CHANGE_MSGB);
	}
}


bool return_true(const MAS::ListItem*, const MAS::ListItem*) {return true;}

void MiscOptions::FillWithSoundDrivers(MAS::ComboBox &cb) {
	for (int i = 0; i < SD_COUNT; ++i)
		cb.list.InsertItem(new ListItemString(SOUND_DRIVER_NAME[i]));

	//prevent sorting
	cb.list.Sort(return_true);
	cb.list.Select(get_config_int("sound", "driver", 0));
}


void MiscOptions::SaveGraphics(Dialog *Parent) {
	//If the user changed anything tell him it won't take effect until the game is restarted.
	const ::Size WrittenDim = ParseDimensionString(get_config_string("graphics", "resolution", ""));
	const ::Size SelectedDim = ParseDimensionString(cResolution.list.GetSelectedItem()->GetText());
	if (WrittenDim != SelectedDim ||
		get_config_int("graphics", "windowed", -1) != (chWindowed.TestFlag(D_SELECTED) ? 1 : 0)) {

		set_config_string("graphics", "resolution", cResolution.list.GetSelectedItem()->GetText());
		set_config_int("graphics", "windowed", chWindowed.TestFlag(D_SELECTED) ? 1 : 0);

		Parent->HandleEvent(*this, MSG_GRAPHICS_CHANGE_MSGB);
	}
}


void MiscOptions::FillWithGfxModes(MAS::ComboBox &cb) {
	GFX_MODE_LIST *gml = NULL;

	/*
	 * Listing of available modes is supported only in fullscreen enviroment. Windowed enviroment
	 * supports all kind of window sizes (resolutions). But since we want to list only window
	 * sizes that make sense, we'll list only available fullscreen modes, even if windowed.
	 */
	gml = get_gfx_mode_list(GFX_OPENGL_FULLSCREEN);

	if (!gml) {
		_ERROR_;
		return;
	}

	int c = 0;
	const std::string SavedDim = get_config_string("graphics", "resolution", "1024x768");
	for (int i = 0; i < gml->num_modes; ++i) {
		const ::Size Dim((gml->mode + i)->width, (gml->mode + i)->height);
#ifdef WIN32
		if (Dim.Width >= 800 && Dim.Height >= 600 && (gml->mode + i)->bpp == 32) {
#else
		if (Dim.Width >= 800 && Dim.Height >= 600) {
#endif
			cb.list.InsertItem(new ListItemString(FormatDimensionString(Dim).c_str()), c);
			if (SavedDim == FormatDimensionString(Dim))
				cb.list.Select(c);
			++c;
		}
	}

	destroy_gfx_mode_list(gml);
}


GUIGameOptions::GUIGameOptions() :
	Window() {

	title.SetText("Game options");
	ClearFlag(D_RESIZABLE);
	MAS::Window::Centre();

	Shape(250, 50, 500, 550);

	bOK.Shape(25, 95, 20, 4, true);
	bOK.SetText("OK");
	bCancel.Shape(55, 95, 20, 4, true);
	bCancel.SetText("CANCEL");

	TP.Shape(10, 5, 470, 480);
	TP.Attach(&GameOpt, "misc options");
	TP.Attach(&KeyConfig, "keyboard");

	Add(bOK);
	Add(bCancel);
	Add(TP);
}


void GUIGameOptions::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Window::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
			if (obj == bCancel) {
				Close();
			}
			else if (obj == bOK) {
				GameOpt.SetSounds();
				GameOpt.SaveSounds(Widget::GetParent());

				KeyConfig.SetKeys();
				KeyConfig.SaveKeys();

				GameOpt.SaveGraphics(Widget::GetParent());

				Close();
			}
		break;
	}
}


#endif //SERVER_ONLY
