/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "gui_about.h"
#include "structures.h"
#include <string>


GUIAbout::GUIAbout() {
	title.SetText("About sparklet");
	ClearFlag(D_RESIZABLE);

	Shape(250, 50, 500, 560);
	MAS::Window::Centre();

	bClose.Shape(40, 95, 20, 4, true);
	bClose.SetText("CLOSE");

	lText.Shape(5, 5, 480, 500);
	lText.SetWordWrap(true);
	lText.SetText(	"Sparklet "SPARKLET_VERSION_STR"\n"
					"\n"
					"by Milan Mimica (milan.mimica@gmail.com)\n"
					"sounds by: Ivan Radolovic and Gordan Kovacic\n"
					"beta testing: Ivan Radolovic\n"
					"\n"
					"\n"
					"Sparklet uses:\n"
					"\n"
					"allegro: game programming library\n"
					"license: gift-ware\n"
					"site: http://alleg.sf.net/\n"
					"\n"
					"allegrogl: a library to mix OpenGL graphics with Allegro routines\n"
					"license: zlib (see ZLIB.txt)\n"
					"site: http://allegrogl.sf.net/\n"
					"\n"
					"zig: extendable client-server game engine\n"
					"license: BSD (see BSD.txt)\n"
					"site: http://zige.sf.net/\n"
					"\n"
					"MASkinG: allegro GUI toolkit (patched)\n"
					"license: zlib (see ZLIB.txt)\n"
					"site: http://sourceforge.net/projects/masking/\n"
					"\n"
					"tinyxml: simple, small, C++ XML parser\n"
					"license: zlib (see ZLIB.txt)\n"
					"site: http://sourceforge.net/projects/masking/\n"
					"\n"
					"pmask: optimized pixel perfect collision detection library\n"
					"license: public domain (written by orz)\n"
					"site: http://sourceforge.net/projects/pmask/\n"
					"\n"
					"\n"
					"This program is free software; you can redistribute it and/or modify it under the "
					"terms of the GNU General Public License as published by the Free Software Foundation; "
					"either version 2 of the License, or (at your option) any later version.\n"
					"\n"
					"http://sparklet.sf.net");

	Add(bClose);
	Add(lText);
}


void GUIAbout::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Window::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
			if (obj == bClose) {
				Close();
			}
		break;
	}
}


#endif //SERVER_ONLY
