/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef GAME_GUI_H
#define GAME_GUI_H

#include <MASkinG.h>

#include "structures.h"
#include "gui_client_options.h"
#include "gui_server_options.h"
#include "gui_game_options.h"
#include "gui_about.h"
#include "gui_message_box.h"


#define MSG_INVALID_PLAYER_NAME_MSGB (MSG_SUSER + 0)
#define MSG_CLIENT_ERROR_MSGB (MSG_SUSER + 1)
#define MSG_SERVER_ERROR_MSGB (MSG_SUSER + 2)
#define MSG_GRAPHICS_CHANGE_MSGB (MSG_SUSER + 3)
#define MSG_SOUND_DRIVER_CHANGE_MSGB (MSG_SUSER + 4)
#define MSG_SERVER_STARTED_MSGB (MSG_SUSER + 5)
#define MSG_INVALID_SERVER_MSGB (MSG_SUSER + 6)



class NetworkServer;
class NetworkClient;


class GameGUI : private MAS::Dialog {
public:
	GameGUI(NetworkServer*, NetworkClient*);
	~GameGUI();

	void Hide() {Displaying = false;}
	void Show() {clear_keybuf(); MAS::Dialog::Redraw(); Displaying = true;}
	bool Process();

	virtual void HandleKeyboardInput();

	static bool Init();
	static void DeInit();

protected:
private:
	MAS::Wallpaper Desktop;

	MAS::Button bStartClient;
	MAS::Button bStartServer;
	MAS::Button bOptions;
	MAS::Button bExit;
	MAS::Button bAbout;

	virtual void HandleEvent(Widget &obj, int msg, int arg1 = 0, int arg2 = 0);

	NetworkServer *Server;
	NetworkClient *Client;

	GUIClientOptions GCI;
	GUIServerOptions GSI;
	GUIGameOptions GGO;
	GUIAbout GA;

	GUIMessageBox ExitMB;
	GUIMessageBox GraphicsChangeMB;
	GUIMessageBox SoundDriverChangeMB;
	GUIMessageBox InvalidNameMB;
	GUIMessageBox InvalidServerMB;
	GUIMessageBox ClientErrorMB;
	GUIMessageBox ServerErrorMB;

	bool Closed;

	bool Displaying;
};


#endif

#endif //SERVER_ONLY
