/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include <alleggl.h>

#undef MessageBox
#undef RootWindow

#include "game_gui.h"
#include "network_server.h"
#include "network_client.h"

#include "sparklet_utils.h"

using namespace MAS;

bool DoFullRedraw = false;


GameGUI::GameGUI(NetworkServer *srv, NetworkClient *cli) :
	Server(srv),
	Client(cli),
	GCI(Client),
	GSI(Server),
	ExitMB(this, "Message", "Do you really want to exit?", NULL, NULL, "Yes", "No", NULL),
	GraphicsChangeMB(this, "Notice", "Please note that graphics changes will", "take effect the next time you start the game.", NULL, "OK", NULL, NULL),
	SoundDriverChangeMB(this, "Notice", "Please note that sound driver change will", "take effect the next time you start the game.", NULL, "OK", NULL, NULL),
	InvalidNameMB(this, "Error", "Please, select a name in player options.", NULL, NULL, "OK", NULL, NULL),
	InvalidServerMB(this, "Error", "Please, select one server from the list", "or input a valid IP/hostname.", NULL, "OK", NULL, NULL),
	ClientErrorMB(this, "Error", "Something got wrong with starting the client.", "Check the log file.", NULL, "OK", NULL, NULL),
	ServerErrorMB(this, "Error", "Something got wrong with starting the server.", "Check the log file.", NULL, "OK", NULL, NULL),
	Closed(false),
	Displaying(true) {

	const std::string LogoPath = FixFilenameSlashes(std::string(DATA_PREFIX) + "bitmaps/gui/logo_s.tga");
	Desktop.Setup(0, 0, 800, 600, 0, 0, LogoPath.c_str(), (Wallpaper::WallpaperStyle)2);

	bStartClient.Shape(40, 20, 20, 4, true);
	bStartServer.Shape(40, 30, 20, 4, true);
	bOptions.Shape(40, 40, 20, 4, true);
	bExit.Shape(40, 50, 20, 4, true);
	bAbout.Shape(87, 95, 10, 3, true);

	bStartClient.SetText("START CLIENT");
	bStartServer.SetText("START SERVER");
	bOptions.SetText("OPTIONS");
	bExit.SetText("EXIT");
	bAbout.SetText("ABOUT");

	Add(Desktop);

	Add(bStartClient);
	Add(bStartServer);
	Add(bOptions);
	Add(bExit);
	Add(bAbout);

	escapeExits = false;

	MsgStart();
}


GameGUI::~ GameGUI() {
	MsgEnd();
}


bool GameGUI::Process() {
	if (Displaying) {
		if (DoFullRedraw && Settings::screenUpdateMethod  == 3)
			driver->InvalidateRect(0, 0, SCREEN_W, SCREEN_H);
		DoFullRedraw = false;

		MsgIdle();
		GCI.Process();
	}

	return Closed;
}


void GameGUI::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Dialog::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
			if (obj == bExit)
				Add(ExitMB);
			else if (obj == bStartClient) {
				Client->Disconnect();
				Add(GCI);
			}
			else if (obj == bStartServer) {
				Server->Stop();
				Add(GSI);
			}
			else if (obj == bOptions)
				Add(GGO);
			else if (obj == bAbout)
				Add(GA);
		break;

		case MSG_CLOSE:
			if (obj == GCI)
				Remove(GCI);
			else if (obj == GSI)
				Remove(GSI);
			else if (obj == GGO)
				Remove(GGO);
			else if (obj == GA)
				Remove(GA);
			else if (obj == ExitMB) {
				if (ExitMB.GetAnswer() == 0)
					Closed = true;
				Remove(ExitMB);
			}
			else if (obj == InvalidNameMB)
				Remove(InvalidNameMB);
			else if (obj == ClientErrorMB)
				Remove(ClientErrorMB);
			else if (obj == ServerErrorMB)
				Remove(ServerErrorMB);
			else if (obj == GraphicsChangeMB)
				Remove(GraphicsChangeMB);
			else if (obj == SoundDriverChangeMB)
				Remove(SoundDriverChangeMB);
			else if (obj == InvalidServerMB)
				Remove(InvalidServerMB);
		break;

		case MSG_INVALID_PLAYER_NAME_MSGB:
			Add(InvalidNameMB);
		break;
		case MSG_CLIENT_ERROR_MSGB:
			Add(ClientErrorMB);
		break;
		case MSG_SERVER_ERROR_MSGB:
			Add(ServerErrorMB);
		break;
		case MSG_GRAPHICS_CHANGE_MSGB:
			Add(GraphicsChangeMB);
		break;
		case MSG_INVALID_SERVER_MSGB:
			Add(InvalidServerMB);
		break;
		case MSG_SERVER_STARTED_MSGB:
			Add(GCI);
		break;
		case MSG_SOUND_DRIVER_CHANGE_MSGB:
			Add(SoundDriverChangeMB);
		break;
	};
}


void GameGUI::HandleKeyboardInput() {
	if (Displaying)
		MAS::Dialog::HandleKeyboardInput();
}


bool GameGUI::Init() {
	Settings::antialiasing = true;
	Settings::guiSound = false;
	Settings::showMouse = true;
	Settings::mouseShadow = false;
	Settings::yield = false;
	Settings::useVideoMemory = false;
	Settings::screenUpdateMethod = get_config_int("graphics", "gui_update_method", 0);

	Timer::Lock();
	Color::OnColorDepthChange();
	alfont_init();

	const std::string SkinPath = FixFilenameSlashes(std::string(DATA_PREFIX) + "skins/Piper.ini");
	theSkin = new Skin(SkinPath.c_str());
	if (!theSkin || theSkin->GetError()) {
		if (is_windowed_mode())
			allegro_message("Error loading skin!\n");
		_SAY("Error loading skin!");
		theSkin = NULL;
		return false;
	}

	return true;
}

void GameGUI::DeInit() {
	alfont_exit();
	delete theSkin;
}


#endif //SERVER_ONLY
