/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "font_server.h"

#include <alleggl.h>
#include "sparklet_utils.h"
#include "exceptions.h"
#include "fonts.h"


using namespace std;


FontServer::FontServer() :
	DataFile(NULL) {

	const string Path = FixFilenameSlashes(string(DATA_PREFIX) + "defs/fonts/fonts.dat");

	if (!exists(Path.c_str()))
		throw ExFileNotFound(Path);

	DataFile = load_datafile(Path.c_str());

	if (DataFile == NULL) {
		_ERROR_;
		_SAY("File '" + Path + "' seems to be corrupt.");
	}

	if (DataFile[PALETTE].type == DAT_PALETTE)
		set_palette ((RGB *)DataFile[PALETTE].dat);
	else
		_ERROR_;
}


FontServer::~FontServer() {
	for (std::map<const int, FONT*>::iterator x = LoadedFont.begin(); x != LoadedFont.end(); ++x)
		allegro_gl_destroy_font(x->second);

	unload_datafile(DataFile);
}


FONT* FontServer::GetFont(const int Font) {
	if (LoadedFont.find(Font) == LoadedFont.end()) {
		LoadedFont.insert(make_pair(Font, LoadFont(Font)));
	}

	return LoadedFont.find(Font)->second;
}


FONT* FontServer::LoadFont(const int Font) {
	if (DataFile[Font].type != DAT_FONT)
		_ERROR_;

	FONT *RetVal = allegro_gl_convert_allegro_font_ex((FONT*)DataFile[Font].dat,
		AGL_FONT_TYPE_TEXTURED,
		-1.f / ((float)SCREEN_W / UNITS_PER_SCREEN_W),
		GL_ALPHA8);

	_SPARKLET_ASSERT(RetVal);

	return RetVal;
}


#endif //SERVER_ONLY
