/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "rock.h"
#include "wall.h"
#include "smoke.h"
#include "spawn_place.h"
#include "health_pack.h"
#include "weapon_pack.h"
#include "ammo_pack.h"
#include "bullet.h"
#include "bomb.h"
#include "missile.h"
#include "particle.h"
#include "bouncing.h"

#include "cli_player_object.h"
#include "cli_particle.h"
#include "cli_bullet.h"
#include "cli_bomb.h"
#include "cli_missile.h"
#include "cli_mobile_object.h"
#include "cli_rotated_object.h"
#include "cli_bouncing.h"
#include "player_object.h"

#include "fps_display.h"
#include "statusbar.h"
#include "screen_mask.h"
#include "message_lister.h"
#include "message_writer.h"


Initializer::Initializer() {
	ObjectFactoryes.insert(make_pair(ROCK_STR, new RockFactory()));
	ObjectFactoryes.insert(make_pair(WALL_STR, new WallFactory()));
	ObjectFactoryes.insert(make_pair(SMOKE_STR, new SmokeFactory()));
	ObjectFactoryes.insert(make_pair(SPAWN_PLACE_STR, new SpawnPlaceFactory()));

	ObjectFactoryes.insert(make_pair(HEALTH_PACK_STR, new HealthPackFactory()));
	ObjectFactoryes.insert(make_pair(WEAPON_PACK_STR, new WeaponPackFactory()));
	ObjectFactoryes.insert(make_pair(AMMO_PACK_STR, new AmmoPackFactory()));
	ObjectFactoryes.insert(make_pair(BOUNCING_STR, new BouncingFactory()));


#ifndef SERVER_ONLY
	CliObjectFactoryes.insert(make_pair(BOUNCING_STR, new CliBouncingFactory()));
	CliObjectFactoryes.insert(make_pair(ROCK_STR, new CliMobileObjectFactory()));
	CliObjectFactoryes.insert(make_pair(PLAYER_OBJECT_STR, new CliPlayerObjectFactory()));
	CliObjectFactoryes.insert(make_pair(EXPL_PARTICLE_STR, new CliParticleFactory()));
	CliObjectFactoryes.insert(make_pair(BULLET_STR, new CliBulletFactory()));
	CliObjectFactoryes.insert(make_pair(BOMB_STR, new CliBombFactory()));
	CliObjectFactoryes.insert(make_pair(MISSILE_STR, new CliMissileFactory()));
	CliObjectFactoryes.insert(make_pair(SPAWN_PLACE_STR, new CliMobileObjectFactory()));
	CliObjectFactoryes.insert(make_pair(WALL_STR, new CliMobileObjectFactory()));
	CliObjectFactoryes.insert(make_pair(SMOKE_STR, new CliMobileObjectFactory()));

	CliObjectFactoryes.insert(make_pair(FPS_DISPLAY_STR, new FPSDisplayFactory()));
	CliObjectFactoryes.insert(make_pair(STATUSBAR_STR, new StatusbarFactory()));
	CliObjectFactoryes.insert(make_pair(SCREEN_MASK_STR, new ScreenMaskFactory()));
	CliObjectFactoryes.insert(make_pair(MESSAGE_LISTER_STR, new MessageListerFactory()));
	CliObjectFactoryes.insert(make_pair(MESSAGE_WRITER_STR, new MessageWriterFactory()));

	CliObjectFactoryes.insert(make_pair(HEALTH_PACK_STR, new CliMobileObjectFactory()));
	CliObjectFactoryes.insert(make_pair(WEAPON_PACK_STR, new CliMobileObjectFactory()));
	CliObjectFactoryes.insert(make_pair(AMMO_PACK_STR, new CliMobileObjectFactory()));
#endif //SERVER_ONLY
}
