/***************************************************************************
 *   Copyright (C) 2003 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ENGINE_H
#define ENGINE_H

#include "complex_object_extension.h"

#include "network_messages.h"

#define ENGINE_STR std::string("engine")
#define ENGINE_TYPE_STR std::string("type")


class Engine : public ComplexObjectExtension {
public:
	Engine(const TiXmlElement *Element, const Rect<float> &Parent, bool SrvMode) :
		ComplexObjectExtension(Element, Parent, SrvMode) {};

	/*The following 4 functions are invoked when the respective key is pressed*/
	virtual void ForwardDown() = 0;
	virtual void BackDown() = 0;
	virtual void RotLeftDown() = 0;
	virtual void RotRightDown() = 0;
	virtual void StrLeftDown() = 0;
	virtual void StrRightDown() = 0;

	/*The following 4 functions are invoked when the respective key is released*/
	virtual void ForwardUp() = 0;
	virtual void BackUp() = 0;
	virtual void RotLeftUp() = 0;
	virtual void RotRightUp() = 0;
	virtual void StrLeftUp() = 0;
	virtual void StrRightUp() = 0;

	/*Return the actual force that affects the parent object. It'a a scalar value:
	positive if invokes the parent to move foward, negative othervise.*/
	virtual float GetForward() = 0;

	/*Return the actual force that affects the parent object. It'a a scalar value:
	positive if invokes the parent to rotate right, negative othervise.*/
	virtual float GetTorque() = 0;

	/*Return the actual force that affects the parent object. It'a a scalar value:
	positive if invokes the parent to strafe right, negative othervise.*/
	virtual float GetStrafe() = 0;

	/*Returns filled EngineInfo strusture ready to be sent over network. You shold
	delete the returned object.*/
	virtual EngineInfo* GetEngineInfo() = 0;

	/*Used only by client te set flames when it receives info from server.*/
#ifndef SERVER_ONLY
	virtual void SetEngineFlame(const EngineInfo* EI) = 0;
#endif //SERVER_ONLY
};

#endif
