/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef COMPLEX_OBJECT_EXTENSION_H
#define COMPLEX_OBJECT_EXTENSION_H


#include "object_extension.h"

class Sprite;


class ComplexObjectExtension : public ObjectExtension {
public:
	ComplexObjectExtension(const TiXmlElement *Element, const Size &Parent, bool SrvMode) :
		ObjectExtension(Element, Parent, SrvMode) {};
	virtual ~ComplexObjectExtension();

#ifndef SERVER_ONLY
	virtual void Render(const Point<float> &Where, const float &Angle) const;
#endif //SERVER_ONLY
	virtual void RenderShape(BITMAP *Dest, BITMAP *tmp);
	virtual void Update();
	virtual bool NeedsUpdate(float TimeElapsed);

protected:
	std::vector<ObjectExtension*> SpriteLayer;
	Sprite* GetBaseSprite(const TiXmlElement *Root, const Rect<float> &Parent);
};

#endif
