/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "complex_object_extension.h"

#include "sprite.h"
#include "statical_sprite.h"

#define BASE_SPRITE_STR std::string("base_sprite")

#define LAYER_COUNT 3



ComplexObjectExtension::~ComplexObjectExtension() {
	for (USHORT x = 0; x < SpriteLayer.size(); ++x) {
		delete SpriteLayer[x];
	}
}


#ifndef SERVER_ONLY
void ComplexObjectExtension::Render(const Point<float> &Where, const float &Angle) const {
	_SPARKLET_ASSERT(!ServerMode);
	for (USHORT LayerNumber = 0; LayerNumber < LAYER_COUNT; LayerNumber++) {
		for (USHORT x = 0; x < SpriteLayer.size(); ++x) {
			_SPARKLET_ASSERT(SpriteLayer[x]->GetLayer() < LAYER_COUNT);
			if (SpriteLayer[x]->GetLayer() == LayerNumber)
				SpriteLayer[x]->Render(Where, Angle);
		}
	}
}
#endif //SERVER_ONLY


void ComplexObjectExtension::RenderShape(BITMAP *Dest, BITMAP *tmp) {
	_SPARKLET_ASSERT(ServerMode);
	for (USHORT x = 0; x < SpriteLayer.size(); ++x) {
		SpriteLayer[x]->RenderShape(Dest, tmp);
	}
}


void ComplexObjectExtension::Update() {
	for (USHORT x = 0; x < SpriteLayer.size(); ++x) {
		SpriteLayer[x]->Update();
	}
}


bool ComplexObjectExtension::NeedsUpdate(float TimeElapsed) {
	bool NeedUpdate = false;
	for (USHORT x = 0; x < SpriteLayer.size(); ++x) {
		NeedUpdate |= SpriteLayer[x]->NeedsUpdate(TimeElapsed);
	}

	return NeedUpdate;
}


Sprite* ComplexObjectExtension::GetBaseSprite(const TiXmlElement *Root, const Rect<float> &Parent) {
	const TiXmlElement *Element = XMLParser::GetChild(Root, BASE_SPRITE_STR);
	Sprite *BaseSprite = new Sprite(Element, Parent, ServerMode);
	SpriteLayer.push_back(BaseSprite);

	return BaseSprite;
}
