/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY

#ifdef _WIN32
	#include <allegro.h>
	#include <winalleg.h>
#endif

#include "cli_rotated_object.h"

#include "sparklet_utils.h"
#include "network_messages.h"

extern float gTimeElapsed;


CliRotatedObject::CliRotatedObject(const TiXmlElement *Root, const Size &Dim, float Scale) :
	CliMobileObject(Root, Dim, Scale),
	Rotation(0) {
}


void CliRotatedObject::SetMsg(const RotationInfo *RI) {
	Direction = RI->Direction;
	Rotation = RI->Rotation;
}


void CliRotatedObject::OnUpdate() {
	Direction += Rotation * gTimeElapsed;
	Direction = BoundAngle(Direction);

	CliMobileObject::OnUpdate();
}


#endif //SERVER_ONLY
