/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "sprite.h"
#include "network_messages.h"
#include "cli_bouncing.h"

#define EXPLOSION_SPRITE_STR std::string("explosion_sprite")
#define CAN_EXPLODE_STR std::string("can_explode")


CliBouncing::CliBouncing(const TiXmlElement *Root, const Size &Dim, float Scale) :
	CliMobileObject(Root, Dim, Scale) {

	CanExplode = XMLParser::GetValueL(Root, CAN_EXPLODE_STR, 1);

	if (CanExplode) {
		const TiXmlElement *EL = XMLParser::GetChild(Root, EXPLOSION_SPRITE_STR);
		Explosion = new Sprite(EL, Geo, false);
		Explosion->Stop();
		Extension.push_back(Explosion);

		Explosion->SetDirection((rand() % (int)(M_PI * 2.f * 100.f)) / 100.f);
		Explosion->Stop();
	}

	GetBaseSprite()->SetFPS(0);
	GetBaseSprite()->Play();
}


void CliBouncing::OnUpdate() {
	if (CanExplode) {
		if (Explosion->IsOver())
			Explosion->Stop();
	}

	CliMobileObject::OnUpdate();
}


void CliBouncing::SetMsg(const StateInfoGeneric1 *SIG) {
	if (SIG->State & 0x80) {
		Explosion->PlayOnce();
		GetBaseSprite()->Stop();
	}
	else {
		GetBaseSprite()->JumpToFrame(SIG->State & (0xff - 0x80));
	}
}


void CliBouncing::SetMsg(const StateInfoGeneric2 *SIG) {
	GetBaseSprite()->SetFPS(SIG->State * 2.f / 10.f);
}


#endif //SERVER_ONLY
