/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "sprite.h"
#include "cli_bomb.h"
#include "network_messages.h"
#include "network_client.h"
#include "sparklet_utils.h"


#define SHAPE_RES_STR std::string("shape_res")
#define MASS_STR std::string("mass")


extern float gTimeElapsed;
extern NetworkClient *gNetworkClient;


CliBomb::CliBomb(const TiXmlElement *Root, const Size &Dim, float Scale) :
	CliMobileObject(Root, Dim, Scale) {

	ShapeRes = XMLParser::GetValueF(Root, SHAPE_RES_STR, 0.1f) * Scale;
	Mass = XMLParser::GetValueF(Root, MASS_STR, 10.f) * Scale;
}


void CliBomb::OnUpdate() {
	Velocity -= CalcResistance(Velocity, ShapeRes * gNetworkClient->GetViscosity() / Mass) * gTimeElapsed;

	CliMobileObject::OnUpdate();
}


#endif //SERVER_ONLY
