/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "sprite.h"
#include "bomb.h"
#include "network_server.h"
#include "sparklet_utils.h"


extern float gTimeElapsed;
extern NetworkServer *gNetworkServer;


Bomb::Bomb(const TiXmlElement* Att, float Scale) :
	Object(Att, Scale),
	MobileObject(Att, Scale),
	PhysicalObject(Att, Scale),
	Projectile(Att, Scale) {

	const TiXmlElement *Root = Parser->GetRoot();

	BaseSprite = Object::GetBaseSprite(Root);
}


void Bomb::OnUpdate() {
	Velocity += Impulse / Mass;
	Velocity -= CalcResistance(Velocity, ShapeRes * gNetworkServer->GetViscosity() / Mass * gTimeElapsed);

	Projectile::OnUpdate();
}


void Bomb::Damage(const PhysicalObject *Obj) {
	Explode();
	Unlink();

	Projectile::Damage(Obj);
}
