/***************************************************************************
                          bitmap_server.h  -  description
                             -------------------
    begin                : Mon Mar 31 2003
    copyright            : (C) 2003 by Milan Mimica
    email                : milan.mimica@gmail.com   
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BITMAP_SERVER_H
#define BITMAP_SERVER_H

#include <allegro.h>
#ifdef WIN32
#include <winalleg.h>
#endif

#ifndef SERVER_ONLY
#include <alleggl.h>
#endif

#include "structures.h"

#include <string>
#include <map>
#include <vector>


struct BITMAP;

/* BitmapServer - implements caching of memory bitmaps and textures
*/
class BitmapServer {
public:
	~BitmapServer();

	//load (if necesary) and return Allegro memory bitmap
	BITMAP* GetBitmap32(const std::string &RelPath);
	BITMAP* GetBitmap16(const std::string &RelPath);

	//Returns a pointer to a memory bitmap sized Dim. The returned bitmap pointers share memory
	//space so you can't use them to store data permanently nor use them at the same time.
	BITMAP* GetBitmap16(const Size &Dim);

#ifndef SERVER_ONLY
	//Uploads the bitmap to GFX memory (if not done before) and returns the OpenGL texture ID of
	//it. The bitmap cannot be destoyed.
	GLuint GetTexture(BITMAP *bmp);
	//Uploads the bitmap to GFX memory and returns the OpenGL texture ID of it. The bitmap can be
	//destroyed.
	GLuint LoadTexture(BITMAP *bmp);
#endif //SERVER_ONLY

private:
	//load and return Allegro memory bitmap
	BITMAP* LoadBitmap32(const std::string &FullPath);
	BITMAP* LoadBitmap16(const std::string &FullPath);

	std::vector<BITMAP*> SharedMem;
	std::map<const std::string, BITMAP*> BitmapList32;
	std::map<const std::string, BITMAP*> BitmapList16;
#ifndef SERVER_ONLY
	std::map<const BITMAP*, GLuint> TextureList;
#endif //SERVER_ONLY
};


#endif
