/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#include "agl_text.h"
#include "font_server.h"


extern FontServer *gFntSrv;


void WriteText(const Point<float> &DstLoc, const std::string &Text, const int &Font, const ULONG &Color) {
	//Get the font by it's number
	FONT *fnt = gFntSrv->GetFont(Font);

	glPushMatrix();

	//render the text
	glEnable(GL_BLEND);
	glColor4ub(getr32(Color), getg32(Color), getb32(Color), geta32(Color));

	//to handle different resolutions properly
	const float x = DstLoc.x * (float)SCREEN_W / UNITS_PER_SCREEN_W;
	const float y = DstLoc.y * (float)SCREEN_H / UNITS_PER_SCREEN_H;
	allegro_gl_printf_ex(fnt, x, y, 0, "%s", Text.c_str());
	glDisable(GL_BLEND);

	glColor4ub(255, 255, 255, 255);
	glPopMatrix();
}


#endif //SERVER_ONLY
