/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SERVER_ONLY


#ifndef AGL_BITMAP_H
#define AGL_BITMAP_H

#include <alleggl.h>

#include "structures.h"

/* AGLBitmap - Wrapper for AllegroGL texture.
  - handles creation, rendering and releasing of OpenGL texture trought AllegroGL interface
  - does not really create and destroy textures, but reather reuse existing texture ID's trought
    BitmapServer interface
*/
class AGLBitmap {
public:
	//Initialize texture from the bitmap at the given path
	AGLBitmap(const std::string &Path);
	//Initialize texture from the bitmap at the given pointer
	AGLBitmap(BITMAP *bmp);

	//render the SrcRect portion of the texture onto dispaly buffer at location DstRect (stretch if
	//needed), rotated by Angle radians
	void Render(const Rect<float> &SrcRect, const Rect<float> &DstRect, const float &Angle) const;
	//reder the SrcRect portion of the texture onto the display buffer at location DstRect (tiled
	//instead of stretched)
	void Tile(const Rect<float> &SrcRect, const Rect<float> &DstRect) const;

	//flip the texture horisontally before rendering
	void HFlip() {DoHFlip = true;}
	//flip the texture vertically before rendering
	void VFlip() {DoVFlip = true;}

private:
	BITMAP* tBmp; //used only in initialization
	const GLuint Texture;

	bool DoHFlip;
	bool DoVFlip;

public:
	const Size Dim;
};

#endif

#endif //SERVER_ONLY
