/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <allegro.h>

#ifdef WIN32
#include <winalleg.h>
#endif

#include "xmlserver.h"

#include "structures.h"
#include "exceptions.h"

#include <sstream>


XMLServer::XMLServer() {
}


XMLServer::~XMLServer() {
	for (std::map<const std::string, TiXmlDocument*>::iterator x = Document.begin(); x != Document.end(); ++x)
		delete x->second;
}


const TiXmlDocument* XMLServer::GetDocument(const std::string &Path) {
	const std::map<const std::string, TiXmlDocument*>::iterator it = Document.find(Path);

	if (it == Document.end()) {
		if (!exists(Path.c_str())) {
			throw ExFileNotFound(Path);
		}

		TiXmlDocument *Doc = new TiXmlDocument(Path.c_str());
		Doc->SetTabSize(4);

		if (!Doc->LoadFile()) {
			_ERROR_;
			if (Doc->Error()) {
				std::ostringstream oss2;
				oss2 << "In file '" << Path << "', line: " << Doc->ErrorRow();
				_SAY(oss2.str());
				_SAY(Doc->ErrorDesc());
				Doc->ClearError();
			}

			delete Doc;
			throw ExMalformedXml(Path);
		}

		Document.insert(make_pair(Path, Doc));

		return Doc;
	}

	return it->second;
}
