/***************************************************************************
 *   Copyright (C) 2003 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef XMLPARSER_H
#define XMLPARSER_H

#include "tinyxml.h"

#include <string>
#include <vector>


typedef std::vector<const TiXmlElement*> TiXmlElementList;


class XMLParser {
public:
	XMLParser(const std::string &XMLFile);

	const TiXmlElement* GetRoot() {return (Document != NULL) ? Document->RootElement() : NULL;}

	const std::string GetFilePath() {return XMLFilePath;}

	static const TiXmlElementList* GetAllChildren(const TiXmlElement *Element, const std::string &Name);
	static const TiXmlElementList* GetChildren(const TiXmlElement *Element, const std::string &Name);
	static const TiXmlElement* GetChild(const TiXmlElement *Element, const std::string &Name);

	static std::string GetName(const TiXmlElement *Element);

	static float GetValueF(const TiXmlElement *Att, const std::string &What, float Default);
	static int GetValueL(const TiXmlElement *Att, const std::string &What, int Default);
	static unsigned long GetValueUL(const TiXmlElement *Att, const std::string &What, unsigned long Default);
	static std::string GetValueS(const TiXmlElement *Att, const std::string &What, const std::string Default);

private:
	const TiXmlDocument *Document;
	std::string XMLFilePath;
};

#endif
